rule win_smac_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.smac."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.smac"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 59 8bd8 8d8514f1ffff c645fc16 e8???????? 6a01 }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8bd8                 | mov                 ebx, eax
            //   8d8514f1ffff         | lea                 eax, [ebp - 0xeec]
            //   c645fc16             | mov                 byte ptr [ebp - 4], 0x16
            //   e8????????           |                     
            //   6a01                 | push                1

        $sequence_1 = { ffd6 8d45e0 50 ff35???????? c745e04d6f7665 c745e446696c65 c745e845785700 }
            // n = 7, score = 200
            //   ffd6                 | call                esi
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   ff35????????         |                     
            //   c745e04d6f7665       | mov                 dword ptr [ebp - 0x20], 0x65766f4d
            //   c745e446696c65       | mov                 dword ptr [ebp - 0x1c], 0x656c6946
            //   c745e845785700       | mov                 dword ptr [ebp - 0x18], 0x577845

        $sequence_2 = { c3 8bff 55 8bec 8b4508 56 8d34c5d0504100 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   8d34c5d0504100       | lea                 esi, [eax*8 + 0x4150d0]

        $sequence_3 = { 668985fcfeffff 668985fefeffff 58 6a5c 66898500ffffff 58 6a63 }
            // n = 7, score = 200
            //   668985fcfeffff       | mov                 word ptr [ebp - 0x104], ax
            //   668985fefeffff       | mov                 word ptr [ebp - 0x102], ax
            //   58                   | pop                 eax
            //   6a5c                 | push                0x5c
            //   66898500ffffff       | mov                 word ptr [ebp - 0x100], ax
            //   58                   | pop                 eax
            //   6a63                 | push                0x63

        $sequence_4 = { 33c0 668985f0efffff 8d8504f1ffff 50 8d85c0efffff 50 56 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   668985f0efffff       | mov                 word ptr [ebp - 0x1010], ax
            //   8d8504f1ffff         | lea                 eax, [ebp - 0xefc]
            //   50                   | push                eax
            //   8d85c0efffff         | lea                 eax, [ebp - 0x1040]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_5 = { 6aff ff7508 bbe9fd0000 50 53 ffd6 8bf8 }
            // n = 7, score = 200
            //   6aff                 | push                -1
            //   ff7508               | push                dword ptr [ebp + 8]
            //   bbe9fd0000           | mov                 ebx, 0xfde9
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   8bf8                 | mov                 edi, eax

        $sequence_6 = { ff35???????? 66898d76ffffff c745a04765744d 66c745a46f64 c645a675 66c745a86546 c645aa69 }
            // n = 7, score = 200
            //   ff35????????         |                     
            //   66898d76ffffff       | mov                 word ptr [ebp - 0x8a], cx
            //   c745a04765744d       | mov                 dword ptr [ebp - 0x60], 0x4d746547
            //   66c745a46f64         | mov                 word ptr [ebp - 0x5c], 0x646f
            //   c645a675             | mov                 byte ptr [ebp - 0x5a], 0x75
            //   66c745a86546         | mov                 word ptr [ebp - 0x58], 0x4665
            //   c645aa69             | mov                 byte ptr [ebp - 0x56], 0x69

        $sequence_7 = { 58 6a5b 66894594 33c0 66894596 58 }
            // n = 6, score = 200
            //   58                   | pop                 eax
            //   6a5b                 | push                0x5b
            //   66894594             | mov                 word ptr [ebp - 0x6c], ax
            //   33c0                 | xor                 eax, eax
            //   66894596             | mov                 word ptr [ebp - 0x6a], ax
            //   58                   | pop                 eax

        $sequence_8 = { 50 ffd6 53 6a07 8d8d34feffff 51 53 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   53                   | push                ebx
            //   6a07                 | push                7
            //   8d8d34feffff         | lea                 ecx, [ebp - 0x1cc]
            //   51                   | push                ecx
            //   53                   | push                ebx

        $sequence_9 = { 50 ff15???????? ffb568f4ffff ff15???????? 56 e8???????? 59 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ffb568f4ffff         | push                dword ptr [ebp - 0xb98]
            //   ff15????????         |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 212992
}