rule win_smanager_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.smanager."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.smanager"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7462cffffffff 7410 6a00 6a00 }
            // n = 4, score = 600
            //   c7462cffffffff       | mov                 dword ptr [esi + 0x2c], 0xffffffff
            //   7410                 | je                  0x12
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_1 = { 8b4608 85c0 7420 a801 }
            // n = 4, score = 600
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22
            //   a801                 | test                al, 1

        $sequence_2 = { 83c602 6a22 56 e8???????? 83c408 85c0 }
            // n = 6, score = 600
            //   83c602               | add                 esi, 2
            //   6a22                 | push                0x22
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax

        $sequence_3 = { 740e 3d45270000 7407 3d46270000 }
            // n = 4, score = 600
            //   740e                 | je                  0x10
            //   3d45270000           | cmp                 eax, 0x2745
            //   7407                 | je                  9
            //   3d46270000           | cmp                 eax, 0x2746

        $sequence_4 = { 51 51 ffd0 83c40c c7460800000000 }
            // n = 5, score = 600
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   ffd0                 | call                eax
            //   83c40c               | add                 esp, 0xc
            //   c7460800000000       | mov                 dword ptr [esi + 8], 0

        $sequence_5 = { 8b7604 6a00 6a00 56 }
            // n = 4, score = 600
            //   8b7604               | mov                 esi, dword ptr [esi + 4]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_6 = { 8b4510 85c0 7407 50 ff15???????? }
            // n = 5, score = 600
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_7 = { 56 68???????? 6a00 6a00 ff15???????? 8bf8 897e28 }
            // n = 7, score = 600
            //   56                   | push                esi
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   897e28               | mov                 dword ptr [esi + 0x28], edi

        $sequence_8 = { ff15???????? 32c0 e9???????? 0f1005???????? }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   0f1005????????       |                     

        $sequence_9 = { 8b43ec 85c0 751d 41f6c040 7408 488b07 }
            // n = 6, score = 100
            //   8b43ec               | dec                 eax
            //   85c0                 | mov                 ecx, esi
            //   751d                 | mov                 eax, dword ptr [edi]
            //   41f6c040             | dec                 eax
            //   7408                 | mov                 ecx, dword ptr [esp + 0x80]
            //   488b07               | mov                 dword ptr [esp + 0x30], eax

        $sequence_10 = { 0000 80ed4a 0044feff ff900100008c }
            // n = 4, score = 100
            //   0000                 | push                esi
            //   80ed4a               | mov                 eax, dword ptr [esi + 8]
            //   0044feff             | test                eax, eax
            //   ff900100008c         | je                  0x24

        $sequence_11 = { 0000 0c0c 0c0c 0c0c 0c0c 0c0c 0102 }
            // n = 7, score = 100
            //   0000                 | push                0
            //   0c0c                 | push                0
            //   0c0c                 | mov                 edi, eax
            //   0c0c                 | mov                 dword ptr [esi + 0x28], edi
            //   0c0c                 | mov                 esi, dword ptr [esi + 4]
            //   0c0c                 | push                0
            //   0102                 | push                0

        $sequence_12 = { 0007 b15a 0089b05a0089 b05a }
            // n = 4, score = 100
            //   0007                 | mov                 cl, 0x57
            //   b15a                 | add                 byte ptr [eax], al
            //   0089b05a0089         | or                  al, 0xc
            //   b05a                 | or                  al, 0xc

        $sequence_13 = { 85c0 745c 448d4368 488d4c2470 33d2 }
            // n = 5, score = 100
            //   85c0                 | mov                 byte ptr [ecx + eax + 0x221b0], al
            //   745c                 | inc                 edx
            //   448d4368             | test                eax, eax
            //   488d4c2470           | je                  0x60
            //   33d2                 | inc                 esp

        $sequence_14 = { 448b842498000000 488b942490000000 488b4c2448 488d842480000000 4533c9 4889442428 895c2420 }
            // n = 7, score = 100
            //   448b842498000000     | dec                 esp
            //   488b942490000000     | mov                 ecx, dword ptr [eax]
            //   488b4c2448           | dec                 ebp
            //   488d842480000000     | test                ecx, ecx
            //   4533c9               | je                  0x1c
            //   4889442428           | inc                 ecx
            //   895c2420             | mov                 eax, 2

        $sequence_15 = { 0008 53 4f 00ef }
            // n = 4, score = 100
            //   0008                 | mov                 cl, 0x5a
            //   53                   | add                 byte ptr [ecx - 0x76ffa550], cl
            //   4f                   | mov                 al, 0x5a
            //   00ef                 | add                 byte ptr [edi], al

        $sequence_16 = { 4863ca 8a441918 42888401b0210200 ffc2 }
            // n = 4, score = 100
            //   4863ca               | dec                 eax
            //   8a441918             | arpl                dx, cx
            //   42888401b0210200     | mov                 al, byte ptr [ecx + ebx + 0x18]
            //   ffc2                 | inc                 edx

        $sequence_17 = { 488bce e8???????? 8b07 488b8c2480000000 89442430 488d442440 448d4301 }
            // n = 7, score = 100
            //   488bce               | movzx               eax, word ptr [edx + ebx]
            //   e8????????           |                     
            //   8b07                 | jne                 0x1e
            //   488b8c2480000000     | dec                 eax
            //   89442430             | and                 eax, 0xfffffffe
            //   488d442440           | dec                 eax
            //   448d4301             | lea                 ecx, [edi + 8]

        $sequence_18 = { 0003 b157 0000 0c0c }
            // n = 4, score = 100
            //   0003                 | sub                 ch, 0x4a
            //   b157                 | add                 byte ptr [esi + edi*8 - 1], al
            //   0000                 | call                dword ptr [eax - 0x73ffffff]
            //   0c0c                 | in                  eax, dx

        $sequence_19 = { b920000000 498bd0 482bd3 488d81deffff7f 4885c0 7417 0fb7041a }
            // n = 7, score = 100
            //   b920000000           | lea                 eax, [ebx + 0x68]
            //   498bd0               | dec                 eax
            //   482bd3               | lea                 ecx, [esp + 0x70]
            //   488d81deffff7f       | xor                 edx, edx
            //   4885c0               | mov                 ecx, 0x20
            //   7417                 | dec                 ecx
            //   0fb7041a             | mov                 edx, eax

        $sequence_20 = { 0007 b15a 00c4 b15a }
            // n = 4, score = 100
            //   0007                 | mov                 cl, 0x5a
            //   b15a                 | add                 byte ptr [edi], al
            //   00c4                 | mov                 cl, 0x5a
            //   b15a                 | add                 byte ptr [ecx - 0x76ffa550], cl

        $sequence_21 = { 0007 b15a 0007 b15a }
            // n = 4, score = 100
            //   0007                 | into                
            //   b15a                 | push                eax
            //   0007                 | add                 byte ptr [eax], cl
            //   b15a                 | into                

        $sequence_22 = { 0001 ce 50 0008 }
            // n = 4, score = 100
            //   0001                 | or                  al, 0xc
            //   ce                   | or                  al, 0xc
            //   50                   | or                  al, 0xc
            //   0008                 | or                  al, 0xc

        $sequence_23 = { 751c 4883e0fe 488d4f08 4c8b08 4d85c9 740c 41b802000000 }
            // n = 7, score = 100
            //   751c                 | dec                 eax
            //   4883e0fe             | sub                 edx, ebx
            //   488d4f08             | dec                 eax
            //   4c8b08               | lea                 eax, [ecx + 0x7fffffde]
            //   4d85c9               | dec                 eax
            //   740c                 | test                eax, eax
            //   41b802000000         | je                  0x26

    condition:
        7 of them and filesize < 10013696
}