rule win_smarteyes_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.smarteyes."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.smarteyes"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 84c9 75f6 8b8da8feffff 8bc1 c1e817 2401 8885dafeffff }
            // n = 7, score = 100
            //   84c9                 | test                cl, cl
            //   75f6                 | jne                 0xfffffff8
            //   8b8da8feffff         | mov                 ecx, dword ptr [ebp - 0x158]
            //   8bc1                 | mov                 eax, ecx
            //   c1e817               | shr                 eax, 0x17
            //   2401                 | and                 al, 1
            //   8885dafeffff         | mov                 byte ptr [ebp - 0x126], al

        $sequence_1 = { 8b7b3c 898580fbffff 33c0 66898594fbffff 8b432c 89859cfbffff 8b4310 }
            // n = 7, score = 100
            //   8b7b3c               | mov                 edi, dword ptr [ebx + 0x3c]
            //   898580fbffff         | mov                 dword ptr [ebp - 0x480], eax
            //   33c0                 | xor                 eax, eax
            //   66898594fbffff       | mov                 word ptr [ebp - 0x46c], ax
            //   8b432c               | mov                 eax, dword ptr [ebx + 0x2c]
            //   89859cfbffff         | mov                 dword ptr [ebp - 0x464], eax
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]

        $sequence_2 = { 84c9 75f9 2bc6 8d8418280a0000 50 e8???????? 8bd8 }
            // n = 7, score = 100
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bc6                 | sub                 eax, esi
            //   8d8418280a0000       | lea                 eax, [eax + ebx + 0xa28]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_3 = { 3bc8 727c 03c0 8945fc 3bc1 7703 894dfc }
            // n = 7, score = 100
            //   3bc8                 | cmp                 ecx, eax
            //   727c                 | jb                  0x7e
            //   03c0                 | add                 eax, eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   3bc1                 | cmp                 eax, ecx
            //   7703                 | ja                  5
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx

        $sequence_4 = { ffb5e0feffff e8???????? 59 8bbde4feffff 8b4508 6a4b 83c708 }
            // n = 7, score = 100
            //   ffb5e0feffff         | push                dword ptr [ebp - 0x120]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bbde4feffff         | mov                 edi, dword ptr [ebp - 0x11c]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   6a4b                 | push                0x4b
            //   83c708               | add                 edi, 8

        $sequence_5 = { 814df800000001 3bd7 7507 814df800008000 8b5d08 57 }
            // n = 6, score = 100
            //   814df800000001       | or                  dword ptr [ebp - 8], 0x1000000
            //   3bd7                 | cmp                 edx, edi
            //   7507                 | jne                 9
            //   814df800008000       | or                  dword ptr [ebp - 8], 0x800000
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   57                   | push                edi

        $sequence_6 = { 33c9 3c01 0f94c1 8d442430 52 51 50 }
            // n = 7, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   3c01                 | cmp                 al, 1
            //   0f94c1               | sete                cl
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_7 = { 50 e8???????? 8b4de4 83c40c 6bc930 8975e0 8db118bb0210 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   83c40c               | add                 esp, 0xc
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8db118bb0210         | lea                 esi, [ecx + 0x1002bb18]

        $sequence_8 = { 56 57 6a09 59 33c0 be1c010000 56 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a09                 | push                9
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   be1c010000           | mov                 esi, 0x11c
            //   56                   | push                esi

        $sequence_9 = { 53 55 56 57 33c0 be???????? 6a06 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax
            //   be????????           |                     
            //   6a06                 | push                6

    condition:
        7 of them and filesize < 429056
}