rule win_smokeloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.smokeloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.smokeloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8d45f0 50 8d45e8 50 8d45e0 50 }
            // n = 7, score = 1200
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax

        $sequence_1 = { 50 6a00 53 ff15???????? 8d45f0 50 }
            // n = 6, score = 1000
            //   50                   | push                eax
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax

        $sequence_2 = { ff15???????? 8bf0 8d45dc 50 6a00 53 }
            // n = 6, score = 1000
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   53                   | push                ebx

        $sequence_3 = { 57 ff15???????? 6a00 6800000002 6a03 }
            // n = 5, score = 1000
            //   57                   | push                edi
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6800000002           | push                0x2000000
            //   6a03                 | push                3

        $sequence_4 = { 50 8d45e0 50 56 ff15???????? 56 ff15???????? }
            // n = 7, score = 1000
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_5 = { 740a 83c104 83f920 72f0 }
            // n = 4, score = 900
            //   740a                 | push                esi
            //   83c104               | push                esi
            //   83f920               | lea                 eax, [ebp - 4]
            //   72f0                 | push                eax

        $sequence_6 = { e8???????? 8bf0 8d45fc 50 ff75fc 56 6a19 }
            // n = 7, score = 900
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   56                   | push                esi
            //   6a19                 | push                0x19

        $sequence_7 = { 0fb64405dc 50 8d45ec 50 }
            // n = 4, score = 900
            //   0fb64405dc           | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d45ec               | push                edi
            //   50                   | push                edi

        $sequence_8 = { 50 56 681f000f00 57 }
            // n = 4, score = 900
            //   50                   | push                eax
            //   56                   | push                esi
            //   681f000f00           | push                0xf001f
            //   57                   | push                edi

        $sequence_9 = { ff15???????? bf90010000 8bcf e8???????? }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   bf90010000           | mov                 edi, 0x190
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     

        $sequence_10 = { 56 8d45fc 50 57 57 6a19 ff75f8 }
            // n = 7, score = 900
            //   56                   | je                  0xb
            //   8d45fc               | push                eax
            //   50                   | push                edi
            //   57                   | inc                 ebx
            //   57                   | lea                 eax, [ebp - 0x10]
            //   6a19                 | push                eax
            //   ff75f8               | lea                 eax, [ebp - 0x18]

        $sequence_11 = { 6800a00f00 50 a3???????? ff15???????? }
            // n = 4, score = 800
            //   6800a00f00           | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   a3????????           |                     
            //   ff15????????         |                     

        $sequence_12 = { 7507 33c0 e9???????? e8???????? b904010000 }
            // n = 5, score = 800
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   e8????????           |                     
            //   b904010000           | mov                 ecx, 0x104

        $sequence_13 = { 668ce8 6685c0 7406 fe05???????? }
            // n = 4, score = 800
            //   668ce8               | lea                 eax, [ebp - 0x24]
            //   6685c0               | push                eax
            //   7406                 | push                0
            //   fe05????????         |                     

        $sequence_14 = { 56 ff15???????? 50 56 6a00 ff15???????? }
            // n = 6, score = 700
            //   56                   | push                ebx
            //   ff15????????         |                     
            //   50                   | lea                 eax, [ebp - 0x10]
            //   56                   | push                0
            //   6a00                 | push                ebx
            //   ff15????????         |                     

        $sequence_15 = { 8b07 03c3 50 ff15???????? }
            // n = 4, score = 700
            //   8b07                 | lea                 eax, [ebp - 0x10]
            //   03c3                 | push                eax
            //   50                   | lea                 eax, [ebp - 0x18]
            //   ff15????????         |                     

        $sequence_16 = { 03c8 81e1ff000000 8a440c18 30042b 43 3b9c241c010000 }
            // n = 6, score = 700
            //   03c8                 | push                dword ptr [ebp - 4]
            //   81e1ff000000         | push                esi
            //   8a440c18             | push                0x19
            //   30042b               | mov                 esi, eax
            //   43                   | lea                 eax, [ebp - 4]
            //   3b9c241c010000       | push                eax

        $sequence_17 = { 8bc3 c745ec25303258 885df0 8945fc }
            // n = 4, score = 700
            //   8bc3                 | push                dword ptr [ebp - 8]
            //   c745ec25303258       | mov                 esi, eax
            //   885df0               | lea                 eax, [ebp - 4]
            //   8945fc               | push                eax

        $sequence_18 = { ffb43108010000 8b84310c010000 03c7 50 8b843104010000 03c5 }
            // n = 6, score = 700
            //   ffb43108010000       | push                dword ptr [ebp - 4]
            //   8b84310c010000       | push                esi
            //   03c7                 | je                  0xc
            //   50                   | add                 ecx, 4
            //   8b843104010000       | cmp                 ecx, 0x20
            //   03c5                 | jb                  0xfffffff5

        $sequence_19 = { 50 53 e8???????? 8d8decfdffff 8d95f0fdffff c70200000000 6800800000 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8d8decfdffff         | lea                 ecx, [ebp - 0x214]
            //   8d95f0fdffff         | lea                 edx, [ebp - 0x210]
            //   c70200000000         | mov                 dword ptr [edx], 0
            //   6800800000           | push                0x8000

        $sequence_20 = { 8db5f8fdffff c60653 56 6a00 }
            // n = 4, score = 500
            //   8db5f8fdffff         | lea                 esi, [ebp - 0x208]
            //   c60653               | mov                 byte ptr [esi], 0x53
            //   56                   | push                esi
            //   6a00                 | push                0

        $sequence_21 = { 8985ecfdffff ffb5f0fdffff 50 53 }
            // n = 4, score = 500
            //   8985ecfdffff         | mov                 dword ptr [ebp - 0x214], eax
            //   ffb5f0fdffff         | push                dword ptr [ebp - 0x210]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_22 = { 8d85f0fdffff 8b750c 8b7d10 50 57 56 }
            // n = 6, score = 500
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_23 = { 89c6 6804010000 56 57 }
            // n = 4, score = 500
            //   89c6                 | mov                 esi, eax
            //   6804010000           | push                0x104
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_24 = { 31c0 66894603 8d8de8fdffff 50 50 }
            // n = 5, score = 500
            //   31c0                 | xor                 eax, eax
            //   66894603             | mov                 word ptr [esi + 3], ax
            //   8d8de8fdffff         | lea                 ecx, [ebp - 0x218]
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_25 = { 50 50 50 51 50 50 56 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   50                   | push                eax
            //   50                   | push                eax
            //   51                   | push                ecx
            //   50                   | push                eax
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_26 = { e8???????? 2500300038 005800 2500300038 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   2500300038           | and                 eax, 0x38003000
            //   005800               | add                 byte ptr [eax], bl
            //   2500300038           | and                 eax, 0x38003000

        $sequence_27 = { fc 5f 5e 5b }
            // n = 4, score = 400
            //   fc                   | mov                 edi, dword ptr [ebp + 0x10]
            //   5f                   | push                eax
            //   5e                   | push                edi
            //   5b                   | push                esi

        $sequence_28 = { 89c6 89cf fc b280 31db a4 }
            // n = 6, score = 400
            //   89c6                 | inc                 ecx
            //   89cf                 | mov                 edi, dword ptr [ebx + 0x1c]
            //   fc                   | xor                 eax, eax
            //   b280                 | lodsb               al, byte ptr [esi]
            //   31db                 | add                 edx, eax
            //   a4                   | test                eax, eax

        $sequence_29 = { 30d0 aa e2f3 7505 }
            // n = 4, score = 400
            //   30d0                 | xor                 al, dl
            //   aa                   | stosb               byte ptr es:[edi], al
            //   e2f3                 | loop                0xfffffff5
            //   7505                 | jne                 7

        $sequence_30 = { 89e5 81ec5c060000 53 56 }
            // n = 4, score = 400
            //   89e5                 | mov                 ebp, esp
            //   81ec5c060000         | sub                 esp, 0x65c
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_31 = { 01c2 31c0 ac 01c2 }
            // n = 4, score = 300
            //   01c2                 | add                 edx, eax
            //   31c0                 | xor                 eax, eax
            //   ac                   | lodsb               al, byte ptr [esi]
            //   01c2                 | add                 edx, eax

        $sequence_32 = { e8???????? 41b919000200 4533c0 4c8bf0 488d4540 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   41b919000200         | dec                 eax
            //   4533c0               | mov                 ebp, esp
            //   4c8bf0               | dec                 eax
            //   488d4540             | sub                 esp, 0x60

        $sequence_33 = { 4c8d4580 488b01 33d2 ff5060 }
            // n = 4, score = 300
            //   4c8d4580             | dec                 eax
            //   488b01               | mov                 edi, ecx
            //   33d2                 | inc                 ecx
            //   ff5060               | mov                 ecx, 0x20019

        $sequence_34 = { 48895c2418 48897c2420 89542410 55 488bec 4883ec60 488bf9 }
            // n = 7, score = 300
            //   48895c2418           | je                  0x25
            //   48897c2420           | dec                 eax
            //   89542410             | mov                 dword ptr [esp + 0x18], ebx
            //   55                   | dec                 eax
            //   488bec               | mov                 dword ptr [esp + 0x20], edi
            //   4883ec60             | mov                 dword ptr [esp + 0x10], edx
            //   488bf9               | push                ebp

        $sequence_35 = { 8b7b24 4c 01c7 668b0c4f 41 8b7b1c 4c }
            // n = 7, score = 300
            //   8b7b24               | mov                 edi, dword ptr [ebx + 0x24]
            //   4c                   | dec                 esp
            //   01c7                 | add                 edi, eax
            //   668b0c4f             | mov                 cx, word ptr [edi + ecx*2]
            //   41                   | inc                 ecx
            //   8b7b1c               | mov                 edi, dword ptr [ebx + 0x1c]
            //   4c                   | dec                 esp

        $sequence_36 = { ac 01c2 85c0 75f0 }
            // n = 4, score = 300
            //   ac                   | lodsb               al, byte ptr [esi]
            //   01c2                 | add                 edx, eax
            //   85c0                 | test                eax, eax
            //   75f0                 | jne                 0xfffffff2

        $sequence_37 = { 4885c0 7428 80383c 7423 }
            // n = 4, score = 300
            //   4885c0               | dec                 eax
            //   7428                 | test                eax, eax
            //   80383c               | je                  0x2a
            //   7423                 | cmp                 byte ptr [eax], 0x3c

        $sequence_38 = { 55 89e5 81ec54040000 53 }
            // n = 4, score = 300
            //   55                   | push                eax
            //   89e5                 | push                eax
            //   81ec54040000         | mov                 edi, dword ptr [ebp + 0x10]
            //   53                   | push                eax

        $sequence_39 = { 4f 8d1c10 41 8b4b18 45 8b6320 4d }
            // n = 7, score = 300
            //   4f                   | dec                 edi
            //   8d1c10               | lea                 ebx, [eax + edx]
            //   41                   | inc                 ecx
            //   8b4b18               | mov                 ecx, dword ptr [ebx + 0x18]
            //   45                   | inc                 ebp
            //   8b6320               | mov                 esp, dword ptr [ebx + 0x20]
            //   4d                   | dec                 ebp

        $sequence_40 = { eb08 4863433c 8b7c1828 488bcb e8???????? 4863d7 498bcc }
            // n = 7, score = 300
            //   eb08                 | inc                 ebp
            //   4863433c             | xor                 eax, eax
            //   8b7c1828             | dec                 esp
            //   488bcb               | mov                 esi, eax
            //   e8????????           |                     
            //   4863d7               | dec                 eax
            //   498bcc               | lea                 eax, [ebp + 0x40]

        $sequence_41 = { 4c 01c7 8b048f 4c }
            // n = 4, score = 300
            //   4c                   | dec                 esp
            //   01c7                 | add                 edi, eax
            //   8b048f               | mov                 eax, dword ptr [edi + ecx*4]
            //   4c                   | dec                 esp

        $sequence_42 = { 8b6320 4d 01c4 ffc9 49 8d3c8c }
            // n = 6, score = 300
            //   8b6320               | mov                 esp, dword ptr [ebx + 0x20]
            //   4d                   | dec                 ebp
            //   01c4                 | add                 esp, eax
            //   ffc9                 | dec                 ecx
            //   49                   | dec                 ecx
            //   8d3c8c               | lea                 edi, [esp + ecx*4]

        $sequence_43 = { 8b957cffffff 895164 6814318b23 8b45e4 50 }
            // n = 5, score = 200
            //   8b957cffffff         | test                eax, eax
            //   895164               | jne                 0xffffff8e
            //   6814318b23           | mov                 edx, dword ptr [ebp - 4]
            //   8b45e4               | imul                ecx, ecx, 0x63
            //   50                   | mov                 eax, dword ptr [ebp + 8]

        $sequence_44 = { 895118 8b4584 8b4db8 89481c 8b5584 8b45b4 }
            // n = 6, score = 200
            //   895118               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b4584               | push                eax
            //   8b4db8               | mov                 eax, dword ptr [ebp - 0x1c]
            //   89481c               | push                eax
            //   8b5584               | mov                 dword ptr [ebp - 0x64], eax
            //   8b45b4               | mov                 ecx, dword ptr [ebp - 0x60]

        $sequence_45 = { 688dbdc13f 8b45e4 50 e8???????? 8945d8 8b4da0 }
            // n = 6, score = 200
            //   688dbdc13f           | xor                 edx, edx
            //   8b45e4               | call                dword ptr [eax + 0x60]
            //   50                   | jmp                 0xa
            //   e8????????           |                     
            //   8945d8               | dec                 eax
            //   8b4da0               | arpl                word ptr [ebx + 0x3c], ax

        $sequence_46 = { 56 57 007508 bbb84340c1 4a }
            // n = 5, score = 200
            //   56                   | mov                 edi, ecx
            //   57                   | cld                 
            //   007508               | mov                 edi, ecx
            //   bbb84340c1           | cld                 
            //   4a                   | mov                 dl, 0x80

        $sequence_47 = { 50 8b4dfc 51 e8???????? 85c0 7589 8b55fc }
            // n = 7, score = 200
            //   50                   | mov                 edi, dword ptr [eax + ebx + 0x28]
            //   8b4dfc               | dec                 eax
            //   51                   | mov                 ecx, ebx
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   7589                 | arpl                di, dx
            //   8b55fc               | dec                 ecx

        $sequence_48 = { c1e002 03471c 8b0428 01e8 5e c3 }
            // n = 6, score = 200
            //   c1e002               | push                edi
            //   03471c               | add                 byte ptr [ebp + 8], dh
            //   8b0428               | mov                 ebx, 0xc14043b8
            //   01e8                 | inc                 eax
            //   5e                   | cmp                 byte ptr [eax], 0
            //   c3                   | jne                 0xfffffffa

        $sequence_49 = { 56 89c2 8b453c 8b7c2878 }
            // n = 4, score = 200
            //   56                   | mov                 bl, 2
            //   89c2                 | mov                 esi, eax
            //   8b453c               | mov                 edi, ecx
            //   8b7c2878             | cld                 

        $sequence_50 = { aa e2f3 7506 7404 }
            // n = 4, score = 200
            //   aa                   | mov                 ebp, esp
            //   e2f3                 | sub                 esp, 0x454
            //   7506                 | push                ebx
            //   7404                 | xor                 al, dl

        $sequence_51 = { 894ddc c745e000000000 8b55e4 3b55dc 0f8327010000 c745e801000000 }
            // n = 6, score = 200
            //   894ddc               | push                eax
            //   c745e000000000       | mov                 dword ptr [ebp - 0x28], eax
            //   8b55e4               | mov                 ecx, dword ptr [ebp - 0x60]
            //   3b55dc               | push                eax
            //   0f8327010000         | mov                 ecx, dword ptr [ebp - 4]
            //   c745e801000000       | push                ecx

        $sequence_52 = { 5b c9 c20800 55 89e5 83ec04 }
            // n = 6, score = 200
            //   5b                   | sub                 esp, 0x454
            //   c9                   | push                ebx
            //   c20800               | push                esi
            //   55                   | ret                 0x10
            //   89e5                 | push                ebp
            //   83ec04               | mov                 ebp, esp

        $sequence_53 = { 8945cc 8b4da0 8b55cc 895144 68d770a437 }
            // n = 5, score = 200
            //   8945cc               | lea                 eax, [eax + 8]
            //   8b4da0               | dec                 eax
            //   8b55cc               | sub                 edx, 8
            //   895144               | push                0x3fc1bd8d
            //   68d770a437           | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_54 = { 58 29c6 d1ee 037724 0fb7442efe c1e002 03471c }
            // n = 7, score = 200
            //   58                   | push                esi
            //   29c6                 | lodsd               eax, dword ptr [esi]
            //   d1ee                 | add                 eax, ebp
            //   037724               | push                esi
            //   0fb7442efe           | mov                 edx, eax
            //   c1e002               | mov                 eax, dword ptr [ebp + 0x3c]
            //   03471c               | mov                 edi, dword ptr [eax + ebp + 0x78]

        $sequence_55 = { c1c108 3208 40 803800 75f5 31d1 }
            // n = 6, score = 200
            //   c1c108               | pop                 eax
            //   3208                 | sub                 esi, eax
            //   40                   | shr                 esi, 1
            //   803800               | add                 esi, dword ptr [edi + 0x24]
            //   75f5                 | movzx               eax, word ptr [esi + ebp - 2]
            //   31d1                 | shl                 eax, 2

        $sequence_56 = { 6bc963 8b4508 33d2 f7f1 }
            // n = 4, score = 200
            //   6bc963               | mov                 ecx, esp
            //   8b4508               | mov                 edx, dword ptr [eax + 4]
            //   33d2                 | mov                 ecx, dword ptr [eax]
            //   f7f1                 | dec                 esp

        $sequence_57 = { 8946fc ad 85c0 75f3 c3 56 }
            // n = 6, score = 200
            //   8946fc               | mov                 dl, 0x80
            //   ad                   | xor                 ebx, ebx
            //   85c0                 | movsb               byte ptr es:[edi], byte ptr [esi]
            //   75f3                 | mov                 bl, 2
            //   c3                   | push                esi
            //   56                   | push                edi

        $sequence_58 = { 8b45e4 50 e8???????? 89459c 8b4da0 8b559c 895158 }
            // n = 7, score = 200
            //   8b45e4               | xor                 edx, edx
            //   50                   | div                 ecx
            //   e8????????           |                     
            //   89459c               | mov                 dword ptr [ebp - 0x34], eax
            //   8b4da0               | mov                 ecx, dword ptr [ebp - 0x60]
            //   8b559c               | mov                 edx, dword ptr [ebp - 0x34]
            //   895158               | mov                 dword ptr [ecx + 0x44], edx

        $sequence_59 = { 8b7c2878 01ef 8b7720 01ee 56 ad 01e8 }
            // n = 7, score = 200
            //   8b7c2878             | xor                 ebx, ebx
            //   01ef                 | movsb               byte ptr es:[edi], byte ptr [esi]
            //   8b7720               | mov                 edi, ecx
            //   01ee                 | cld                 
            //   56                   | mov                 dl, 0x80
            //   ad                   | xor                 ebx, ebx
            //   01e8                 | movsb               byte ptr es:[edi], byte ptr [esi]

        $sequence_60 = { 5d 5d 2e3f 3438 }
            // n = 4, score = 100
            //   5d                   | pop                 esp
            //   5d                   | salc                
            //   2e3f                 | sub                 byte ptr [ecx - 0x2a], dl
            //   3438                 | pop                 ebp

        $sequence_61 = { 9d d418 a1???????? 0da20e09d8 }
            // n = 4, score = 100
            //   9d                   | jne                 0xa
            //   d418                 | stosb               byte ptr es:[edi], al
            //   a1????????           |                     
            //   0da20e09d8           | loop                0xfffffff5

        $sequence_62 = { b0b6 49 92 06 4e 55 }
            // n = 6, score = 100
            //   b0b6                 | jne                 0xa
            //   49                   | je                  0xa
            //   92                   | add                 byte ptr [ebp + 0x6c], dl
            //   06                   | popfd               
            //   4e                   | aam                 0x18
            //   55                   | test                eax, 0xd44910d6

        $sequence_63 = { 00556c 9d d418 a9d61049d4 5c d6 2851d6 }
            // n = 7, score = 100
            //   00556c               | stosb               byte ptr es:[edi], al
            //   9d                   | loop                0xfffffff5
            //   d418                 | jne                 0xa
            //   a9d61049d4           | je                  0xa
            //   5c                   | pop                 ebx
            //   d6                   | leave               
            //   2851d6               | ret                 8

        $sequence_64 = { 5d 5d 5d 5d 285b29 59 }
            // n = 6, score = 100
            //   5d                   | push                ebp
            //   5d                   | mov                 ebp, esp
            //   5d                   | sub                 esp, 4
            //   5d                   | xor                 al, dl
            //   285b29               | stosb               byte ptr es:[edi], al
            //   59                   | loop                0xfffffff5

    condition:
        7 of them and filesize < 245760
}