rule win_smominru_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.smominru."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.smominru"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894634 8b4718 894638 8b471c 89463c 8b4720 894640 }
            // n = 7, score = 100
            //   894634               | mov                 dword ptr [esi + 0x34], eax
            //   8b4718               | mov                 eax, dword ptr [edi + 0x18]
            //   894638               | mov                 dword ptr [esi + 0x38], eax
            //   8b471c               | mov                 eax, dword ptr [edi + 0x1c]
            //   89463c               | mov                 dword ptr [esi + 0x3c], eax
            //   8b4720               | mov                 eax, dword ptr [edi + 0x20]
            //   894640               | mov                 dword ptr [esi + 0x40], eax

        $sequence_1 = { 8b5604 0fa5d0 8907 83c604 }
            // n = 4, score = 100
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   0fa5d0               | shld                eax, edx, cl
            //   8907                 | mov                 dword ptr [edi], eax
            //   83c604               | add                 esi, 4

        $sequence_2 = { 8b55fc ff5704 837b0c08 7549 }
            // n = 4, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   ff5704               | call                dword ptr [edi + 4]
            //   837b0c08             | cmp                 dword ptr [ebx + 0xc], 8
            //   7549                 | jne                 0x4b

        $sequence_3 = { 8d6c2400 6aff 68b0f3e877 ff7508 }
            // n = 4, score = 100
            //   8d6c2400             | lea                 ebp, [esp]
            //   6aff                 | push                -1
            //   68b0f3e877           | push                0x77e8f3b0
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_4 = { c9 c20c00 57 5f 55 54 }
            // n = 6, score = 100
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   57                   | push                edi
            //   5f                   | pop                 edi
            //   55                   | push                ebp
            //   54                   | push                esp

        $sequence_5 = { 8b55fc f76a14 c1e002 50 8b45fc }
            // n = 5, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   f76a14               | imul                dword ptr [edx + 0x14]
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_6 = { 8b5604 81e2ffffff7f 03c2 8bd0 }
            // n = 4, score = 100
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   81e2ffffff7f         | and                 edx, 0x7fffffff
            //   03c2                 | add                 eax, edx
            //   8bd0                 | mov                 edx, eax

        $sequence_7 = { 8b5604 81ca00000002 33c9 8a8b15020000 }
            // n = 4, score = 100
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   81ca00000002         | or                  edx, 0x2000000
            //   33c9                 | xor                 ecx, ecx
            //   8a8b15020000         | mov                 cl, byte ptr [ebx + 0x215]

        $sequence_8 = { e8???????? 33c0 894704 894708 89470c 894710 894714 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   894708               | mov                 dword ptr [edi + 8], eax
            //   89470c               | mov                 dword ptr [edi + 0xc], eax
            //   894710               | mov                 dword ptr [edi + 0x10], eax
            //   894714               | mov                 dword ptr [edi + 0x14], eax

        $sequence_9 = { ff15???????? 85c0 0f8c5f37ac7b 33c0 40 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8c5f37ac7b         | jl                  0x7bac3765
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax

        $sequence_10 = { 8b5604 59 e8???????? 85c0 }
            // n = 4, score = 100
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_11 = { 8b5604 3bfa 7372 8b1e }
            // n = 4, score = 100
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   3bfa                 | cmp                 edi, edx
            //   7372                 | jae                 0x74
            //   8b1e                 | mov                 ebx, dword ptr [esi]

        $sequence_12 = { 8b55fc ff560c 8b450c ff00 }
            // n = 4, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   ff560c               | call                dword ptr [esi + 0xc]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   ff00                 | inc                 dword ptr [eax]

        $sequence_13 = { 8bc6 5e c9 c20800 8d7f00 55 }
            // n = 6, score = 100
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   8d7f00               | lea                 edi, [edi]
            //   55                   | push                ebp

        $sequence_14 = { 5f 55 8d6c2400 8b450c }
            // n = 4, score = 100
            //   5f                   | pop                 edi
            //   55                   | push                ebp
            //   8d6c2400             | lea                 ebp, [esp]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_15 = { 8975e0 8975dc 8975c0 8975c8 39750c 0f841948ab7b }
            // n = 6, score = 100
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8975dc               | mov                 dword ptr [ebp - 0x24], esi
            //   8975c0               | mov                 dword ptr [ebp - 0x40], esi
            //   8975c8               | mov                 dword ptr [ebp - 0x38], esi
            //   39750c               | cmp                 dword ptr [ebp + 0xc], esi
            //   0f841948ab7b         | je                  0x7bab481f

    condition:
        7 of them and filesize < 8167424
}