rule win_snatch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snatch"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 488d056ee50e00 e8???????? e9???????? 488d054de50e00 e8???????? e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d056ee50e00       | dec                 eax
            //   e8????????           |                     
            //   e9????????           |                     
            //   488d054de50e00       | mov                 dword ptr [esp], ecx
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_1 = { e8???????? 488b7c2408 48c747080c000000 833d????????00 7577 488d0d8aba2600 48890f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b7c2408           | lea                 eax, [0x175e54]
            //   48c747080c000000     | dec                 eax
            //   833d????????00       |                     
            //   7577                 | mov                 dword ptr [esp + 0xd8], eax
            //   488d0d8aba2600       | dec                 eax
            //   48890f               | mov                 dword ptr [esp + 0xe0], edi

        $sequence_2 = { e8???????? 0f57c0 e9???????? 488d05e0111800 48890424 4889742408 48895c2410 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0f57c0               | dec                 eax
            //   e9????????           |                     
            //   488d05e0111800       | lea                 eax, [0x28dbde]
            //   48890424             | dec                 eax
            //   4889742408           | mov                 dword ptr [esp], eax
            //   48895c2410           | dec                 eax

        $sequence_3 = { eb0c 488d05196d2f00 e8???????? 48c7471000000000 488d05d6e02800 48890424 48897c2408 }
            // n = 7, score = 100
            //   eb0c                 | lea                 eax, [0x1577bc]
            //   488d05196d2f00       | dec                 eax
            //   e8????????           |                     
            //   48c7471000000000     | mov                 dword ptr [esp], eax
            //   488d05d6e02800       | dec                 eax
            //   48890424             | mov                 eax, dword ptr [esp + 8]
            //   48897c2408           | dec                 eax

        $sequence_4 = { f20f5ccd f20f58e8 f20f114c2420 f20f116c2418 f20f111c24 e8???????? f20f10442420 }
            // n = 7, score = 100
            //   f20f5ccd             | jmp                 0x7a8
            //   f20f58e8             | cmp                 eax, 0xffff
            //   f20f114c2420         | ja                  0x6fc
            //   f20f116c2418         | dec                 eax
            //   f20f111c24           | mov                 eax, dword ptr [esp + 0xa0]
            //   e8????????           |                     
            //   f20f10442420         | ret                 

        $sequence_5 = { 48c7400836000000 833d????????00 7539 488d0d7bfc1a00 488908 488d0d92962000 488b542478 }
            // n = 7, score = 100
            //   48c7400836000000     | dec                 eax
            //   833d????????00       |                     
            //   7539                 | lea                 edx, [eax + ecx]
            //   488d0d7bfc1a00       | dec                 eax
            //   488908               | mov                 dword ptr [esp + 0x78], edx
            //   488d0d92962000       | dec                 eax
            //   488b542478           | mov                 ebx, dword ptr [edi + 0xd8]

        $sequence_6 = { e9???????? e8???????? 488d052ea63600 48890424 48c744240803000000 e8???????? e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   e8????????           |                     
            //   488d052ea63600       | nop                 
            //   48890424             | dec                 eax
            //   48c744240803000000     | lea    eax, [0x1120aa]
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_7 = { e9???????? 488d057b3e1300 e8???????? e9???????? 488d0566521300 e8???????? e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d057b3e1300       | dec                 eax
            //   e8????????           |                     
            //   e9????????           |                     
            //   488d0566521300       | shl                 ecx, 3
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_8 = { ebbd 488d5102 488b5c2470 4839da 0f87ea000000 66c704080d0a 488b4c2450 }
            // n = 7, score = 100
            //   ebbd                 | mov                 dword ptr [esp], ecx
            //   488d5102             | dec                 eax
            //   488b5c2470           | lea                 ecx, [0x160c09]
            //   4839da               | dec                 eax
            //   0f87ea000000         | mov                 dword ptr [esp + 8], ecx
            //   66c704080d0a         | nop                 
            //   488b4c2450           | nop                 

        $sequence_9 = { 4889542430 90 488d0583350a00 48890424 e8???????? 488b7c2408 48c7470813000000 }
            // n = 7, score = 100
            //   4889542430           | dec                 eax
            //   90                   | mov                 dword ptr [esp], edx
            //   488d0583350a00       | call                ecx
            //   48890424             | cmp                 dword ptr [esp + 8], 0
            //   e8????????           |                     
            //   488b7c2408           | dec                 eax
            //   48c7470813000000     | mov                 eax, dword ptr [esp + 0x28]

    condition:
        7 of them and filesize < 12846080
}