rule win_snatchcrypto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.snatchcrypto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snatchcrypto"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 4889ae60030000 488b9330060000 488d0d6e0a0300 e8???????? 4889442460 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   4889ae60030000       | lea                 edx, [0x3e7fc]
            //   488b9330060000       | dec                 eax
            //   488d0d6e0a0300       | mov                 ecx, ebx
            //   e8????????           |                     
            //   4889442460           | dec                 eax

        $sequence_1 = { e8???????? 488d4d81 33d2 41b803010000 c6458000 e8???????? 488d8db1020000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   488d4d81             | mov                 dword ptr [esi - 8], eax
            //   33d2                 | movzx               ecx, al
            //   41b803010000         | inc                 ebp
            //   c6458000             | xor                 eax, dword ptr [edx + ecx*4 + 0x8a180]
            //   e8????????           |                     
            //   488d8db1020000       | inc                 ecx

        $sequence_2 = { c1c80b 410bca 458bc2 4433c8 4123ce 418bc4 c1c806 }
            // n = 7, score = 200
            //   c1c80b               | add                 ecx, eax
            //   410bca               | inc                 esp
            //   458bc2               | movzx               eax, word ptr [ebx + 0x48]
            //   4433c8               | dec                 eax
            //   4123ce               | lea                 edx, [0x2a687]
            //   418bc4               | dec                 eax
            //   c1c806               | mov                 ecx, edi

        $sequence_3 = { 740d 4c39b380010000 0f858b000000 bfc4feffff 488b4310 4c8b7c2470 4c8b6c2478 }
            // n = 7, score = 200
            //   740d                 | lea                 ecx, [ebp + 0x2bd2]
            //   4c39b380010000       | jne                 0x331
            //   0f858b000000         | dec                 eax
            //   bfc4feffff           | test                ebx, ebx
            //   488b4310             | je                  0x305
            //   4c8b7c2470           | inc                 ebp
            //   4c8b6c2478           | movzx               eax, word ptr [esp]

        $sequence_4 = { 7499 488d1597280600 488bcf e8???????? 85c0 7486 488d158c280600 }
            // n = 7, score = 200
            //   7499                 | movzx               ecx, al
            //   488d1597280600       | inc                 ecx
            //   488bcf               | and                 ebx, 0xff0000
            //   e8????????           |                     
            //   85c0                 | inc                 ecx
            //   7486                 | mov                 eax, dword ptr [edi + ecx*4]
            //   488d158c280600       | and                 eax, 0xff00

        $sequence_5 = { 0fb605???????? 4188440f02 48635320 4c634324 48039590020000 4183c703 418bcf }
            // n = 7, score = 200
            //   0fb605????????       |                     
            //   4188440f02           | cmp                 dword ptr [edi + 0x10], 0
            //   48635320             | jne                 0x1c0e
            //   4c634324             | dec                 eax
            //   48039590020000       | lea                 edx, [0x3174e]
            //   4183c703             | dec                 eax
            //   418bcf               | lea                 edx, [0x3172a]

        $sequence_6 = { 4889742418 57 4881ece0010000 488b05???????? 4833c4 48898424d0010000 488b7908 }
            // n = 7, score = 200
            //   4889742418           | dec                 eax
            //   57                   | mov                 ecx, dword ptr [edi + 0x18]
            //   4881ece0010000       | dec                 eax
            //   488b05????????       |                     
            //   4833c4               | mov                 edx, ebp
            //   48898424d0010000     | dec                 eax
            //   488b7908             | add                 ecx, 0x1c4

        $sequence_7 = { 8bd8 85c0 0f85d3000000 4885f6 7416 488bce e8???????? }
            // n = 7, score = 200
            //   8bd8                 | dec                 eax
            //   85c0                 | mov                 ecx, dword ptr [esp + 0x30]
            //   0f85d3000000         | dec                 eax
            //   4885f6               | xor                 ecx, esp
            //   7416                 | dec                 eax
            //   488bce               | add                 esp, 0x40
            //   e8????????           |                     

        $sequence_8 = { 0fb78b94030000 0fb7937e020000 410fb7c0 450fb7c8 c1e904 83e101 66c1e80a }
            // n = 7, score = 200
            //   0fb78b94030000       | dec                 eax
            //   0fb7937e020000       | lea                 edx, [0x1dca6]
            //   410fb7c0             | dec                 ecx
            //   450fb7c8             | mov                 ecx, esi
            //   c1e904               | jmp                 0x1a50
            //   83e101               | inc                 ecx
            //   66c1e80a             | mov                 dword ptr [edi + ebp*4 + 0x630], 2

        $sequence_9 = { 410fb6cb e8???????? 85c0 7547 448d4005 0fb6d3 410fb6cb }
            // n = 7, score = 200
            //   410fb6cb             | xor                 ebx, ebx
            //   e8????????           |                     
            //   85c0                 | inc                 esp
            //   7547                 | mov                 dword ptr [ebx], ebx
            //   448d4005             | dec                 esp
            //   0fb6d3               | mov                 dword ptr [ebx + 0x4e0], ebx
            //   410fb6cb             | dec                 esp

    condition:
        7 of them and filesize < 1400832
}