rule win_sneepy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sneepy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sneepy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 c3 8bff 55 8bec b8e41a0000 e8???????? }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   b8e41a0000           | mov                 eax, 0x1ae4
            //   e8????????           |                     

        $sequence_1 = { 6888130000 ffd6 68???????? c705????????e8d44000 e8???????? 83c404 }
            // n = 6, score = 100
            //   6888130000           | push                0x1388
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   c705????????e8d44000     |     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_2 = { 8b4dfc 33c0 83ff01 5b 0f94c0 }
            // n = 5, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33c0                 | xor                 eax, eax
            //   83ff01               | cmp                 edi, 1
            //   5b                   | pop                 ebx
            //   0f94c0               | sete                al

        $sequence_3 = { c1fa05 8b149560314100 59 c1e006 59 8a4dff 80c901 }
            // n = 7, score = 100
            //   c1fa05               | sar                 edx, 5
            //   8b149560314100       | mov                 edx, dword ptr [edx*4 + 0x413160]
            //   59                   | pop                 ecx
            //   c1e006               | shl                 eax, 6
            //   59                   | pop                 ecx
            //   8a4dff               | mov                 cl, byte ptr [ebp - 1]
            //   80c901               | or                  cl, 1

        $sequence_4 = { 52 8945dc c745c801000000 8975cc }
            // n = 4, score = 100
            //   52                   | push                edx
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   c745c801000000       | mov                 dword ptr [ebp - 0x38], 1
            //   8975cc               | mov                 dword ptr [ebp - 0x34], esi

        $sequence_5 = { 89b5c0feffff 46 83fe07 7cdf }
            // n = 4, score = 100
            //   89b5c0feffff         | mov                 dword ptr [ebp - 0x140], esi
            //   46                   | inc                 esi
            //   83fe07               | cmp                 esi, 7
            //   7cdf                 | jl                  0xffffffe1

        $sequence_6 = { 85c0 7459 81bdb0feffffc8000000 7526 8b3d???????? 8d8dc0feffff 51 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7459                 | je                  0x5b
            //   81bdb0feffffc8000000     | cmp    dword ptr [ebp - 0x150], 0xc8
            //   7526                 | jne                 0x28
            //   8b3d????????         |                     
            //   8d8dc0feffff         | lea                 ecx, [ebp - 0x140]
            //   51                   | push                ecx

        $sequence_7 = { e8???????? 8bc6 c1f805 8b048560314100 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8b048560314100       | mov                 eax, dword ptr [eax*4 + 0x413160]

        $sequence_8 = { 83e103 f3a4 8d8df0feffff 68???????? 51 e8???????? }
            // n = 6, score = 100
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_9 = { 33c0 8945e4 83f805 7d10 668b4c4310 66890c4514314100 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   83f805               | cmp                 eax, 5
            //   7d10                 | jge                 0x12
            //   668b4c4310           | mov                 cx, word ptr [ebx + eax*2 + 0x10]
            //   66890c4514314100     | mov                 word ptr [eax*2 + 0x413114], cx

    condition:
        7 of them and filesize < 188416
}