rule win_snifula_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.snifula."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snifula"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 33f6 8d936c0e0000 6a05 58 50 56 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   33f6                 | xor                 esi, esi
            //   8d936c0e0000         | lea                 edx, [ebx + 0xe6c]
            //   6a05                 | push                5
            //   58                   | pop                 eax
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_1 = { 57 8d4c2420 e8???????? 8bd8 3bdd 7524 57 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bdd                 | cmp                 ebx, ebp
            //   7524                 | jne                 0x26
            //   57                   | push                edi

        $sequence_2 = { 40 8907 8d442414 50 56 56 8d7904 }
            // n = 7, score = 200
            //   40                   | inc                 eax
            //   8907                 | mov                 dword ptr [edi], eax
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   56                   | push                esi
            //   56                   | push                esi
            //   8d7904               | lea                 edi, [ecx + 4]

        $sequence_3 = { 7436 8b4728 a820 7416 ff7710 8b4708 }
            // n = 6, score = 200
            //   7436                 | je                  0x38
            //   8b4728               | mov                 eax, dword ptr [edi + 0x28]
            //   a820                 | test                al, 0x20
            //   7416                 | je                  0x18
            //   ff7710               | push                dword ptr [edi + 0x10]
            //   8b4708               | mov                 eax, dword ptr [edi + 8]

        $sequence_4 = { 8345ec04 3b45e8 7295 eb1b 8b4df8 8b45f4 8b0488 }
            // n = 7, score = 200
            //   8345ec04             | add                 dword ptr [ebp - 0x14], 4
            //   3b45e8               | cmp                 eax, dword ptr [ebp - 0x18]
            //   7295                 | jb                  0xffffff97
            //   eb1b                 | jmp                 0x1d
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b0488               | mov                 eax, dword ptr [eax + ecx*4]

        $sequence_5 = { bf???????? 57 53 ff15???????? 8bf0 85f6 7414 }
            // n = 7, score = 200
            //   bf????????           |                     
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7414                 | je                  0x16

        $sequence_6 = { 7602 8bf0 8b4d10 6a00 56 ff7508 e8???????? }
            // n = 7, score = 200
            //   7602                 | jbe                 4
            //   8bf0                 | mov                 esi, eax
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_7 = { 8bf8 ff35???????? 8b35???????? ffd6 53 89442414 }
            // n = 6, score = 200
            //   8bf8                 | mov                 edi, eax
            //   ff35????????         |                     
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   53                   | push                ebx
            //   89442414             | mov                 dword ptr [esp + 0x14], eax

        $sequence_8 = { 6a04 8d45fc 50 6a04 56 68???????? ff7508 }
            // n = 7, score = 200
            //   6a04                 | push                4
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a04                 | push                4
            //   56                   | push                esi
            //   68????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_9 = { 5e 5b c9 c20400 8d4804 ba1e010000 56 }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   8d4804               | lea                 ecx, [eax + 4]
            //   ba1e010000           | mov                 edx, 0x11e
            //   56                   | push                esi

    condition:
        7 of them and filesize < 188416
}