rule win_snojan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.snojan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snojan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d442bfc c744240804000000 c7442404???????? 890424 }
            // n = 4, score = 200
            //   8d442bfc             | lea                 eax, [ebx + ebp - 4]
            //   c744240804000000     | mov                 dword ptr [esp + 8], 4
            //   c7442404????????     |                     
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_1 = { 81c43c900100 31c0 5b 5e 5f }
            // n = 5, score = 200
            //   81c43c900100         | add                 esp, 0x1903c
            //   31c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi

        $sequence_2 = { 8b4dc0 6689810000986d 83c30c 81fb???????? 0f8285feffff e9???????? }
            // n = 6, score = 200
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]
            //   6689810000986d       | mov                 word ptr [ecx + 0x6d980000], ax
            //   83c30c               | add                 ebx, 0xc
            //   81fb????????         |                     
            //   0f8285feffff         | jb                  0xfffffe8b
            //   e9????????           |                     

        $sequence_3 = { 83f8ff 0f8452010000 c7442404???????? c70424???????? e8???????? 85c0 89c6 }
            // n = 7, score = 200
            //   83f8ff               | cmp                 eax, -1
            //   0f8452010000         | je                  0x158
            //   c7442404????????     |                     
            //   c70424????????       |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   89c6                 | mov                 esi, eax

        $sequence_4 = { 31db eb02 89c3 8d4301 8b14859026986d 85d2 }
            // n = 6, score = 200
            //   31db                 | xor                 ebx, ebx
            //   eb02                 | jmp                 4
            //   89c3                 | mov                 ebx, eax
            //   8d4301               | lea                 eax, [ebx + 1]
            //   8b14859026986d       | mov                 edx, dword ptr [eax*4 + 0x6d982690]
            //   85d2                 | test                edx, edx

        $sequence_5 = { e8???????? 29c4 c744240806000000 c744240401000000 c7042402000000 ff15???????? 83ec0c }
            // n = 7, score = 200
            //   e8????????           |                     
            //   29c4                 | sub                 esp, eax
            //   c744240806000000     | mov                 dword ptr [esp + 8], 6
            //   c744240401000000     | mov                 dword ptr [esp + 4], 1
            //   c7042402000000       | mov                 dword ptr [esp], 2
            //   ff15????????         |                     
            //   83ec0c               | sub                 esp, 0xc

        $sequence_6 = { 85c9 0f84c3feffff e9???????? 0fb7810000986d 894dc0 89c7 }
            // n = 6, score = 200
            //   85c9                 | test                ecx, ecx
            //   0f84c3feffff         | je                  0xfffffec9
            //   e9????????           |                     
            //   0fb7810000986d       | movzx               eax, word ptr [ecx + 0x6d980000]
            //   894dc0               | mov                 dword ptr [ebp - 0x40], ecx
            //   89c7                 | mov                 edi, eax

        $sequence_7 = { 56 53 e8???????? 29c4 c744240806000000 c744240401000000 c7042402000000 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   29c4                 | sub                 esp, eax
            //   c744240806000000     | mov                 dword ptr [esp + 8], 6
            //   c744240401000000     | mov                 dword ptr [esp + 4], 1
            //   c7042402000000       | mov                 dword ptr [esp], 2

        $sequence_8 = { 7421 85db 740c ff149d9026986d 83eb01 75f4 }
            // n = 6, score = 200
            //   7421                 | je                  0x23
            //   85db                 | test                ebx, ebx
            //   740c                 | je                  0xe
            //   ff149d9026986d       | call                dword ptr [ebx*4 + 0x6d982690]
            //   83eb01               | sub                 ebx, 1
            //   75f4                 | jne                 0xfffffff6

        $sequence_9 = { b8???????? e8???????? 85c0 74e9 a1???????? 8b988000986d }
            // n = 6, score = 200
            //   b8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   74e9                 | je                  0xffffffeb
            //   a1????????           |                     
            //   8b988000986d         | mov                 ebx, dword ptr [eax + 0x6d980080]

    condition:
        7 of them and filesize < 90112
}