rule win_snowflake_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.snowflake_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snowflake_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff750c 6a5c 53 e8???????? 8b6c2448 56 ff7504 }
            // n = 7, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   6a5c                 | push                0x5c
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b6c2448             | mov                 ebp, dword ptr [esp + 0x48]
            //   56                   | push                esi
            //   ff7504               | push                dword ptr [ebp + 4]

        $sequence_1 = { ff742428 e8???????? 83c414 eb88 3dab000000 7530 837c243400 }
            // n = 7, score = 100
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   eb88                 | jmp                 0xffffff8a
            //   3dab000000           | cmp                 eax, 0xab
            //   7530                 | jne                 0x32
            //   837c243400           | cmp                 dword ptr [esp + 0x34], 0

        $sequence_2 = { ff3408 ff742444 e8???????? 8b7c2440 83c414 89442410 85c0 }
            // n = 7, score = 100
            //   ff3408               | push                dword ptr [eax + ecx]
            //   ff742444             | push                dword ptr [esp + 0x44]
            //   e8????????           |                     
            //   8b7c2440             | mov                 edi, dword ptr [esp + 0x40]
            //   83c414               | add                 esp, 0x14
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   85c0                 | test                eax, eax

        $sequence_3 = { e8???????? 59 59 8b4c243c 85c9 7409 51 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b4c243c             | mov                 ecx, dword ptr [esp + 0x3c]
            //   85c9                 | test                ecx, ecx
            //   7409                 | je                  0xb
            //   51                   | push                ecx

        $sequence_4 = { ff7640 e8???????? 83c42c 85c0 7533 6a08 8d442418 }
            // n = 7, score = 100
            //   ff7640               | push                dword ptr [esi + 0x40]
            //   e8????????           |                     
            //   83c42c               | add                 esp, 0x2c
            //   85c0                 | test                eax, eax
            //   7533                 | jne                 0x35
            //   6a08                 | push                8
            //   8d442418             | lea                 eax, [esp + 0x18]

        $sequence_5 = { ff742444 ff742440 50 e8???????? 8bf0 83c414 85f6 }
            // n = 7, score = 100
            //   ff742444             | push                dword ptr [esp + 0x44]
            //   ff742440             | push                dword ptr [esp + 0x40]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c414               | add                 esp, 0x14
            //   85f6                 | test                esi, esi

        $sequence_6 = { c744240c01000000 eb08 3c2b 0f8593000000 46 8a0e 0fb6c1 }
            // n = 7, score = 100
            //   c744240c01000000     | mov                 dword ptr [esp + 0xc], 1
            //   eb08                 | jmp                 0xa
            //   3c2b                 | cmp                 al, 0x2b
            //   0f8593000000         | jne                 0x99
            //   46                   | inc                 esi
            //   8a0e                 | mov                 cl, byte ptr [esi]
            //   0fb6c1               | movzx               eax, cl

        $sequence_7 = { e8???????? 59 59 85c0 7507 8b4510 2138 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   2138                 | and                 dword ptr [eax], edi

        $sequence_8 = { c744240800000000 29f1 89c6 1b7c2414 f7de c1fe1f 01f1 }
            // n = 7, score = 100
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   29f1                 | sub                 ecx, esi
            //   89c6                 | mov                 esi, eax
            //   1b7c2414             | sbb                 edi, dword ptr [esp + 0x14]
            //   f7de                 | neg                 esi
            //   c1fe1f               | sar                 esi, 0x1f
            //   01f1                 | add                 ecx, esi

        $sequence_9 = { ff743234 ff7524 ff742428 53 e8???????? 8b542428 83c414 }
            // n = 7, score = 100
            //   ff743234             | push                dword ptr [edx + esi + 0x34]
            //   ff7524               | push                dword ptr [ebp + 0x24]
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   83c414               | add                 esp, 0x14

    condition:
        7 of them and filesize < 6196224
}