rule win_socks5_systemz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.socks5_systemz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.socks5_systemz"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf1 6a4c e8???????? 8bc8 83c404 894c240c c744241800000000 }
            // n = 7, score = 500
            //   8bf1                 | mov                 esi, ecx
            //   6a4c                 | push                0x4c
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   83c404               | add                 esp, 4
            //   894c240c             | mov                 dword ptr [esp + 0xc], ecx
            //   c744241800000000     | mov                 dword ptr [esp + 0x18], 0

        $sequence_1 = { 50 ff7314 ff7310 e8???????? 8b4310 83c410 }
            // n = 6, score = 500
            //   50                   | push                eax
            //   ff7314               | push                dword ptr [ebx + 0x14]
            //   ff7310               | push                dword ptr [ebx + 0x10]
            //   e8????????           |                     
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]
            //   83c410               | add                 esp, 0x10

        $sequence_2 = { ff10 56 8b35???????? 6a00 ffd6 50 ffd3 }
            // n = 7, score = 500
            //   ff10                 | call                dword ptr [eax]
            //   56                   | push                esi
            //   8b35????????         |                     
            //   6a00                 | push                0
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   ffd3                 | call                ebx

        $sequence_3 = { 83c148 e9???????? c3 b8???????? }
            // n = 4, score = 500
            //   83c148               | add                 ecx, 0x48
            //   e9????????           |                     
            //   c3                   | ret                 
            //   b8????????           |                     

        $sequence_4 = { 8b4dec 83c134 e9???????? 8b542408 8d42e4 8b4ae0 }
            // n = 6, score = 500
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   83c134               | add                 ecx, 0x34
            //   e9????????           |                     
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8d42e4               | lea                 eax, [edx - 0x1c]
            //   8b4ae0               | mov                 ecx, dword ptr [edx - 0x20]

        $sequence_5 = { 8975a0 e9???????? 8b45a0 6aff }
            // n = 4, score = 500
            //   8975a0               | mov                 dword ptr [ebp - 0x60], esi
            //   e9????????           |                     
            //   8b45a0               | mov                 eax, dword ptr [ebp - 0x60]
            //   6aff                 | push                -1

        $sequence_6 = { 33ed 896c2414 eb0d 50 ff15???????? 8be8 }
            // n = 6, score = 500
            //   33ed                 | xor                 ebp, ebp
            //   896c2414             | mov                 dword ptr [esp + 0x14], ebp
            //   eb0d                 | jmp                 0xf
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8be8                 | mov                 ebp, eax

        $sequence_7 = { 8d44240c 50 8d4c2414 e8???????? c744241c01000000 89742420 c74424380f000000 }
            // n = 7, score = 500
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   50                   | push                eax
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   e8????????           |                     
            //   c744241c01000000     | mov                 dword ptr [esp + 0x1c], 1
            //   89742420             | mov                 dword ptr [esp + 0x20], esi
            //   c74424380f000000     | mov                 dword ptr [esp + 0x38], 0xf

    condition:
        7 of them and filesize < 1417216
}