rule win_socksbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.socksbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.socksbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a0d 50 8945fc e8???????? 8bf8 }
            // n = 5, score = 300
            //   6a0d                 | push                0xd
            //   50                   | push                eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_1 = { 8d85acfeffff 50 51 c785acfeffff01000000 899db0feffff 894df0 c745f400879303 }
            // n = 7, score = 300
            //   8d85acfeffff         | lea                 eax, [ebp - 0x154]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   c785acfeffff01000000     | mov    dword ptr [ebp - 0x154], 1
            //   899db0feffff         | mov                 dword ptr [ebp - 0x150], ebx
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   c745f400879303       | mov                 dword ptr [ebp - 0xc], 0x3938700

        $sequence_2 = { 33c0 5f c9 c20400 55 8bec 81ec0c030000 }
            // n = 7, score = 300
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec0c030000         | sub                 esp, 0x30c

        $sequence_3 = { 324415bc 320439 32c3 880439 }
            // n = 4, score = 300
            //   324415bc             | xor                 al, byte ptr [ebp + edx - 0x44]
            //   320439               | xor                 al, byte ptr [ecx + edi]
            //   32c3                 | xor                 al, bl
            //   880439               | mov                 byte ptr [ecx + edi], al

        $sequence_4 = { 33c1 c1e002 33c1 c1e002 }
            // n = 4, score = 300
            //   33c1                 | xor                 eax, ecx
            //   c1e002               | shl                 eax, 2
            //   33c1                 | xor                 eax, ecx
            //   c1e002               | shl                 eax, 2

        $sequence_5 = { c3 8b400c 8b00 ff30 ff15???????? 85c0 74eb }
            // n = 7, score = 300
            //   c3                   | ret                 
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ff30                 | push                dword ptr [eax]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   74eb                 | je                  0xffffffed

        $sequence_6 = { 03f3 eb6d 8b460c 03c3 }
            // n = 4, score = 300
            //   03f3                 | add                 esi, ebx
            //   eb6d                 | jmp                 0x6f
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   03c3                 | add                 eax, ebx

        $sequence_7 = { 8b55f8 43 8802 8b35???????? 33c0 3bdf }
            // n = 6, score = 300
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   43                   | inc                 ebx
            //   8802                 | mov                 byte ptr [edx], al
            //   8b35????????         |                     
            //   33c0                 | xor                 eax, eax
            //   3bdf                 | cmp                 ebx, edi

        $sequence_8 = { 880e 4a 75f7 5f 5e 5d c3 }
            // n = 7, score = 300
            //   880e                 | mov                 byte ptr [esi], cl
            //   4a                   | dec                 edx
            //   75f7                 | jne                 0xfffffff9
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_9 = { a3???????? c605????????00 5b c9 c3 }
            // n = 5, score = 300
            //   a3????????           |                     
            //   c605????????00       |                     
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 73728
}