rule win_socksproxygo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.socksproxygo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.socksproxygo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 48ffc6 4c89d1 4889d7 488b542448 4885c9 0f84ec000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   48ffc6               | dec                 eax
            //   4c89d1               | mov                 dword ptr [eax + 8], ecx
            //   4889d7               | dec                 eax
            //   488b542448           | mov                 dword ptr [esp + 0x68], ebx
            //   4885c9               | nop                 
            //   0f84ec000000         | dec                 eax

        $sequence_1 = { e9???????? 4c8b9424e8010000 0f1f00 4d85d2 742b 498b02 498b5a08 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4c8b9424e8010000     | dec                 eax
            //   0f1f00               | lea                 ebp, [esp + 0x30]
            //   4d85d2               | dec                 eax
            //   742b                 | mov                 dword ptr [esp + 0x40], eax
            //   498b02               | dec                 eax
            //   498b5a08             | mov                 dword ptr [esp + 0x48], ebx

        $sequence_2 = { eb08 488bb42420010000 48899424a0000000 4889b424a8000000 488bbc24a0000000 4885ff 7421 }
            // n = 7, score = 100
            //   eb08                 | mov                 dword ptr [esp + 0x5d], esi
            //   488bb42420010000     | dec                 eax
            //   48899424a0000000     | mov                 esi, 0x9ef3bfea
            //   4889b424a8000000     | cmp                 al, ch
            //   488bbc24a0000000     | add                 byte ptr [ecx + ecx*4 - 0x31], cl
            //   4885ff               | dec                 eax
            //   7421                 | mov                 dword ptr [esp + 0x240], edx

        $sequence_3 = { eb3a 498b02 498b5a08 498b4a10 488b942408020000 488b3a 488b7208 }
            // n = 7, score = 100
            //   eb3a                 | mov                 dword ptr [esp + 0xa18], ebx
            //   498b02               | dec                 eax
            //   498b5a08             | mov                 ecx, dword ptr [esp + 0x1550]
            //   498b4a10             | dec                 eax
            //   488b942408020000     | mov                 edx, dword ptr [ecx + 8]
            //   488b3a               | dec                 eax
            //   488b7208             | mov                 eax, dword ptr [esp + 0xfe8]

        $sequence_4 = { 90 488d05c3392300 0f1f00 e8???????? 488b942418010000 48895008 833d????????00 }
            // n = 7, score = 100
            //   90                   | ja                  0x12b2
            //   488d05c3392300       | inc                 ecx
            //   0f1f00               | cmp                 ecx, 0x3e2307d4
            //   e8????????           |                     
            //   488b942418010000     | inc                 esp
            //   48895008             | mov                 ecx, dword ptr [esp + 0x1c]
            //   833d????????00       |                     

        $sequence_5 = { c64424216b c744242200000203 66c74424260202 31c0 eb1a 440fb64c341d 418d1411 }
            // n = 7, score = 100
            //   c64424216b           | nop                 word ptr [eax + eax]
            //   c744242200000203     | dec                 eax
            //   66c74424260202       | cmp                 esi, 4
            //   31c0                 | dec                 eax
            //   eb1a                 | add                 ecx, 2
            //   440fb64c341d         | dec                 eax
            //   418d1411             | cmp                 ecx, 4

        $sequence_6 = { 4989c0 4989ca 488b842420020000 41c6043805 b901000000 e9???????? 4983fb01 }
            // n = 7, score = 100
            //   4989c0               | inc                 esp
            //   4989ca               | movzx               ebp, byte ptr [esp + 0xae]
            //   488b842420020000     | inc                 esp
            //   41c6043805           | mov                 byte ptr [esp + 0x68], ch
            //   b901000000           | inc                 esp
            //   e9????????           |                     
            //   4983fb01             | movzx               ebp, byte ptr [esp + 0x78]

        $sequence_7 = { e8???????? 488bac24f8000000 4881c400010000 c3 e8???????? e8???????? 4889c3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bac24f8000000     | jne                 0x663
            //   4881c400010000       | dec                 eax
            //   c3                   | mov                 ecx, dword ptr [esp + 0x14a8]
            //   e8????????           |                     
            //   e8????????           |                     
            //   4889c3               | dec                 eax

        $sequence_8 = { 7331 488d05b4513000 4889d9 4889fb 4889f7 4c89c6 e8???????? }
            // n = 7, score = 100
            //   7331                 | inc                 esp
            //   488d05b4513000       | mov                 byte ptr [esp + 0x51], ch
            //   4889d9               | inc                 esp
            //   4889fb               | movzx               edi, byte ptr [esp + 0x5d]
            //   4889f7               | inc                 esp
            //   4c89c6               | mov                 byte ptr [esp + 0x50], bh
            //   e8????????           |                     

        $sequence_9 = { c7442464345c35c5 c7442467c5fab82a 31c0 e9???????? 488b9424a8000000 4885d2 b801000000 }
            // n = 7, score = 100
            //   c7442464345c35c5     | dec                 ecx
            //   c7442467c5fab82a     | mov                 eax, eax
            //   31c0                 | dec                 eax
            //   e9????????           |                     
            //   488b9424a8000000     | imul                eax, edx
            //   4885d2               | dec                 eax
            //   b801000000           | xor                 eax, ecx

    condition:
        7 of them and filesize < 14221312
}