rule win_solarbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.solarbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.solarbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745f800000000 6a00 8d55fc 52 89da 8b0a }
            // n = 6, score = 300
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   6a00                 | push                0
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   52                   | push                edx
            //   89da                 | mov                 edx, ebx
            //   8b0a                 | mov                 ecx, dword ptr [edx]

        $sequence_1 = { 8945fc 8b7d14 8b4518 8945f4 8b451c c745ec00000000 6a00 }
            // n = 7, score = 300
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b7d14               | mov                 edi, dword ptr [ebp + 0x14]
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   6a00                 | push                0

        $sequence_2 = { 8b55f8 01d0 50 8b55fc 8b45f8 01c2 52 }
            // n = 7, score = 300
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   01d0                 | add                 eax, edx
            //   50                   | push                eax
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   01c2                 | add                 edx, eax
            //   52                   | push                edx

        $sequence_3 = { 8b85f8feffff 8b5020 0395f0feffff 89d8 c1e002 01c2 }
            // n = 6, score = 300
            //   8b85f8feffff         | mov                 eax, dword ptr [ebp - 0x108]
            //   8b5020               | mov                 edx, dword ptr [eax + 0x20]
            //   0395f0feffff         | add                 edx, dword ptr [ebp - 0x110]
            //   89d8                 | mov                 eax, ebx
            //   c1e002               | shl                 eax, 2
            //   01c2                 | add                 edx, eax

        $sequence_4 = { 8b8524f8ffff 0fb610 83fa50 0f8598000000 83bd20f8ffff21 0f868b000000 }
            // n = 6, score = 300
            //   8b8524f8ffff         | mov                 eax, dword ptr [ebp - 0x7dc]
            //   0fb610               | movzx               edx, byte ptr [eax]
            //   83fa50               | cmp                 edx, 0x50
            //   0f8598000000         | jne                 0x9e
            //   83bd20f8ffff21       | cmp                 dword ptr [ebp - 0x7e0], 0x21
            //   0f868b000000         | jbe                 0x91

        $sequence_5 = { 89ca 8d1453 0fb712 85d2 7ff3 89c8 }
            // n = 6, score = 300
            //   89ca                 | mov                 edx, ecx
            //   8d1453               | lea                 edx, [ebx + edx*2]
            //   0fb712               | movzx               edx, word ptr [edx]
            //   85d2                 | test                edx, edx
            //   7ff3                 | jg                  0xfffffff5
            //   89c8                 | mov                 eax, ecx

        $sequence_6 = { 8945a8 e9???????? ff75a4 ff75e0 681a040000 }
            // n = 5, score = 300
            //   8945a8               | mov                 dword ptr [ebp - 0x58], eax
            //   e9????????           |                     
            //   ff75a4               | push                dword ptr [ebp - 0x5c]
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   681a040000           | push                0x41a

        $sequence_7 = { 0f8580020000 8b85d0fdffff 85c0 0f8472020000 c785e0fdffff00000000 bf00000000 be00000000 }
            // n = 7, score = 300
            //   0f8580020000         | jne                 0x286
            //   8b85d0fdffff         | mov                 eax, dword ptr [ebp - 0x230]
            //   85c0                 | test                eax, eax
            //   0f8472020000         | je                  0x278
            //   c785e0fdffff00000000     | mov    dword ptr [ebp - 0x220], 0
            //   bf00000000           | mov                 edi, 0
            //   be00000000           | mov                 esi, 0

        $sequence_8 = { 8945e0 eb2d 6a1c 8d45e4 50 }
            // n = 5, score = 300
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   eb2d                 | jmp                 0x2f
            //   6a1c                 | push                0x1c
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax

        $sequence_9 = { 50 e8???????? 89c3 53 e8???????? 8945f4 89f0 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   89f0                 | mov                 eax, esi

    condition:
        7 of them and filesize < 204800
}