rule win_spaceship_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spaceship."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spaceship"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? f2ae 8bcb 4f c1e902 f3a5 8bcb }
            // n = 7, score = 100
            //   68????????           |                     
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8bcb                 | mov                 ecx, ebx
            //   4f                   | dec                 edi
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bcb                 | mov                 ecx, ebx

        $sequence_1 = { 66395cc416 f3a4 74c1 81e2ffff0000 83c9ff 03d0 33c0 }
            // n = 7, score = 100
            //   66395cc416           | cmp                 word ptr [esp + eax*8 + 0x16], bx
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   74c1                 | je                  0xffffffc3
            //   81e2ffff0000         | and                 edx, 0xffff
            //   83c9ff               | or                  ecx, 0xffffffff
            //   03d0                 | add                 edx, eax
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 66c78424bc0100000d00 66898424be010000 c78424c00100001c6b4100 66c78424c40100002500 }
            // n = 4, score = 100
            //   66c78424bc0100000d00     | mov    word ptr [esp + 0x1bc], 0xd
            //   66898424be010000     | mov                 word ptr [esp + 0x1be], ax
            //   c78424c00100001c6b4100     | mov    dword ptr [esp + 0x1c0], 0x416b1c
            //   66c78424c40100002500     | mov    word ptr [esp + 0x1c4], 0x25

        $sequence_3 = { 8bcb 83e103 f3a4 83c9ff bf???????? f2ae f7d1 }
            // n = 7, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   bf????????           |                     
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx

        $sequence_4 = { f2ae 8bcb 4f c1e902 f3a5 8b45f0 }
            // n = 6, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8bcb                 | mov                 ecx, ebx
            //   4f                   | dec                 edi
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_5 = { 80a0c0d9410000 40 3bc6 72be 5e c9 c3 }
            // n = 7, score = 100
            //   80a0c0d9410000       | and                 byte ptr [eax + 0x41d9c0], 0
            //   40                   | inc                 eax
            //   3bc6                 | cmp                 eax, esi
            //   72be                 | jb                  0xffffffc0
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_6 = { 6a00 6810040000 ff15???????? 8bf0 56 ffd5 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6810040000           | push                0x410
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   56                   | push                esi
            //   ffd5                 | call                ebp

        $sequence_7 = { 66899c24e6040000 c78424e80400001c674100 66c78424ec0400004a00 66899c24ee040000 c78424f004000014674100 66c78424f40400001e00 66899c24f6040000 }
            // n = 7, score = 100
            //   66899c24e6040000     | mov                 word ptr [esp + 0x4e6], bx
            //   c78424e80400001c674100     | mov    dword ptr [esp + 0x4e8], 0x41671c
            //   66c78424ec0400004a00     | mov    word ptr [esp + 0x4ec], 0x4a
            //   66899c24ee040000     | mov                 word ptr [esp + 0x4ee], bx
            //   c78424f004000014674100     | mov    dword ptr [esp + 0x4f0], 0x416714
            //   66c78424f40400001e00     | mov    word ptr [esp + 0x4f4], 0x1e
            //   66899c24f6040000     | mov                 word ptr [esp + 0x4f6], bx

        $sequence_8 = { 8a441c0c 8d741c0c 84c0 75bc 5f 5e }
            // n = 6, score = 100
            //   8a441c0c             | mov                 al, byte ptr [esp + ebx + 0xc]
            //   8d741c0c             | lea                 esi, [esp + ebx + 0xc]
            //   84c0                 | test                al, al
            //   75bc                 | jne                 0xffffffbe
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_9 = { c7842408050000f8664100 66c784240c0500002000 6689ac240e050000 c7842410050000f0664100 66899c2414050000 6689842416050000 c7842418050000e4664100 }
            // n = 7, score = 100
            //   c7842408050000f8664100     | mov    dword ptr [esp + 0x508], 0x4166f8
            //   66c784240c0500002000     | mov    word ptr [esp + 0x50c], 0x20
            //   6689ac240e050000     | mov                 word ptr [esp + 0x50e], bp
            //   c7842410050000f0664100     | mov    dword ptr [esp + 0x510], 0x4166f0
            //   66899c2414050000     | mov                 word ptr [esp + 0x514], bx
            //   6689842416050000     | mov                 word ptr [esp + 0x516], ax
            //   c7842418050000e4664100     | mov    dword ptr [esp + 0x518], 0x4166e4

    condition:
        7 of them and filesize < 262144
}