rule win_sparrow_door_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sparrow_door."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sparrow_door"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4c242c 33ed 03e8 13cb }
            // n = 4, score = 100
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   33ed                 | xor                 ebp, ebp
            //   03e8                 | add                 ebp, eax
            //   13cb                 | adc                 ecx, ebx

        $sequence_1 = { ffd7 8b1d???????? 50 ffd3 3bc5 740c }
            // n = 6, score = 100
            //   ffd7                 | call                edi
            //   8b1d????????         |                     
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   3bc5                 | cmp                 eax, ebp
            //   740c                 | je                  0xe

        $sequence_2 = { 53 51 885c241c e8???????? 83c40c 6882050000 8d542454 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   885c241c             | mov                 byte ptr [esp + 0x1c], bl
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6882050000           | push                0x582
            //   8d542454             | lea                 edx, [esp + 0x54]

        $sequence_3 = { 83c414 8d542450 52 57 ff15???????? 85c0 0f8599feffff }
            // n = 7, score = 100
            //   83c414               | add                 esp, 0x14
            //   8d542450             | lea                 edx, [esp + 0x50]
            //   52                   | push                edx
            //   57                   | push                edi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8599feffff         | jne                 0xfffffe9f

        $sequence_4 = { 50 c684242401000000 e8???????? 68f3010000 8d8c241d030000 56 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   c684242401000000     | mov                 byte ptr [esp + 0x124], 0
            //   e8????????           |                     
            //   68f3010000           | push                0x1f3
            //   8d8c241d030000       | lea                 ecx, [esp + 0x31d]
            //   56                   | push                esi

        $sequence_5 = { 85c0 743c 8b442418 8d4c2414 51 6a0b }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   743c                 | je                  0x3e
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   6a0b                 | push                0xb

        $sequence_6 = { 53 55 8b6c240c 57 6a00 6880000000 6a03 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   8b6c240c             | mov                 ebp, dword ptr [esp + 0xc]
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a03                 | push                3

        $sequence_7 = { 8b35???????? ffd6 8b0d???????? 6a64 }
            // n = 4, score = 100
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   8b0d????????         |                     
            //   6a64                 | push                0x64

        $sequence_8 = { 837c242064 0f8d58010000 d16c241c 7508 }
            // n = 4, score = 100
            //   837c242064           | cmp                 dword ptr [esp + 0x20], 0x64
            //   0f8d58010000         | jge                 0x15e
            //   d16c241c             | shr                 dword ptr [esp + 0x1c], 1
            //   7508                 | jne                 0xa

        $sequence_9 = { 68ff1f0000 8d8c24c9000000 6a00 51 895c241c }
            // n = 5, score = 100
            //   68ff1f0000           | push                0x1fff
            //   8d8c24c9000000       | lea                 ecx, [esp + 0xc9]
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   895c241c             | mov                 dword ptr [esp + 0x1c], ebx

    condition:
        7 of them and filesize < 155648
}