rule win_spedear_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spedear."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spedear"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83e207 03c2 c1f803 83c40c 85c0 }
            // n = 5, score = 600
            //   83e207               | and                 edx, 7
            //   03c2                 | add                 eax, edx
            //   c1f803               | sar                 eax, 3
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax

        $sequence_1 = { 53 50 e8???????? 8b7e0c 895e10 }
            // n = 5, score = 500
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b7e0c               | mov                 edi, dword ptr [esi + 0xc]
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx

        $sequence_2 = { 8b4718 8a5f06 50 894608 e8???????? }
            // n = 5, score = 500
            //   8b4718               | mov                 eax, dword ptr [edi + 0x18]
            //   8a5f06               | mov                 bl, byte ptr [edi + 6]
            //   50                   | push                eax
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   e8????????           |                     

        $sequence_3 = { 6a00 6a00 57 8bd8 ffd6 6a00 8d442414 }
            // n = 7, score = 400
            //   6a00                 | add                 esp, 0xc
            //   6a00                 | test                eax, eax
            //   57                   | mov                 eax, dword ptr [edi + 0x18]
            //   8bd8                 | mov                 bl, byte ptr [edi + 6]
            //   ffd6                 | push                eax
            //   6a00                 | mov                 dword ptr [esi + 8], eax
            //   8d442414             | mov                 bl, byte ptr [edi + 6]

        $sequence_4 = { 894618 ffd7 89461c 5f }
            // n = 4, score = 400
            //   894618               | mov                 dword ptr [esi + 0x18], eax
            //   ffd7                 | call                edi
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax
            //   5f                   | pop                 edi

        $sequence_5 = { e8???????? 83c404 3bc5 740a c700???????? 8bd8 eb02 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   83c404               | test                eax, eax
            //   3bc5                 | cdq                 
            //   740a                 | and                 edx, 7
            //   c700????????         |                     
            //   8bd8                 | add                 eax, edx
            //   eb02                 | sar                 eax, 3

        $sequence_6 = { 8906 8b44241c 5e 33d1 5d }
            // n = 5, score = 400
            //   8906                 | mov                 dword ptr [esi], eax
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   5e                   | pop                 esi
            //   33d1                 | xor                 edx, ecx
            //   5d                   | pop                 ebp

        $sequence_7 = { 8b4604 8b571c 83c410 83c120 53 e8???????? 3bdd }
            // n = 7, score = 400
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   8b571c               | mov                 edx, dword ptr [edi + 0x1c]
            //   83c410               | add                 esp, 0x10
            //   83c120               | add                 ecx, 0x20
            //   53                   | push                ebx
            //   e8????????           |                     
            //   3bdd                 | cmp                 ebx, ebp

        $sequence_8 = { 85c0 7536 85f6 742c 833e00 741e 8b5608 }
            // n = 7, score = 400
            //   85c0                 | test                eax, eax
            //   7536                 | jne                 0x38
            //   85f6                 | test                esi, esi
            //   742c                 | je                  0x2e
            //   833e00               | cmp                 dword ptr [esi], 0
            //   741e                 | je                  0x20
            //   8b5608               | mov                 edx, dword ptr [esi + 8]

        $sequence_9 = { 6a00 68???????? e8???????? 83c40c 68d0070000 }
            // n = 5, score = 400
            //   6a00                 | push                0
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   68d0070000           | push                0x7d0

        $sequence_10 = { 741a 6a00 6a00 ff7608 ff5604 6800800000 6a00 }
            // n = 7, score = 300
            //   741a                 | je                  0x1c
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff5604               | call                dword ptr [esi + 4]
            //   6800800000           | push                0x8000
            //   6a00                 | push                0

        $sequence_11 = { 394878 7456 39487c 7451 }
            // n = 4, score = 300
            //   394878               | cmp                 dword ptr [eax + 0x78], ecx
            //   7456                 | je                  0x58
            //   39487c               | cmp                 dword ptr [eax + 0x7c], ecx
            //   7451                 | je                  0x53

        $sequence_12 = { 8bc7 5e 5f 5b 5d c3 6a08 }
            // n = 7, score = 300
            //   8bc7                 | mov                 eax, edi
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a08                 | push                8

        $sequence_13 = { 83450c04 33c7 ff4d08 8b7dfc }
            // n = 4, score = 200
            //   83450c04             | add                 dword ptr [ebp + 0xc], 4
            //   33c7                 | xor                 eax, edi
            //   ff4d08               | dec                 dword ptr [ebp + 8]
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]

        $sequence_14 = { c745fc12000000 33ff 895d08 8b5d0c 0fb61c19 c1e708 }
            // n = 6, score = 200
            //   c745fc12000000       | mov                 dword ptr [ebp - 4], 0x12
            //   33ff                 | xor                 edi, edi
            //   895d08               | mov                 dword ptr [ebp + 8], ebx
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   0fb61c19             | movzx               ebx, byte ptr [ecx + ebx]
            //   c1e708               | shl                 edi, 8

        $sequence_15 = { 4c8bda 418b10 498d6b44 498bd9 498bf8 }
            // n = 5, score = 100
            //   4c8bda               | test                ecx, ecx
            //   418b10               | je                  0x15
            //   498d6b44             | dec                 eax
            //   498bd9               | add                 ebx, 8
            //   498bf8               | dec                 eax

        $sequence_16 = { 8b4610 3998a0000000 760f 3998a4000000 7607 57 56 }
            // n = 7, score = 100
            //   8b4610               | push                0
            //   3998a0000000         | push                0
            //   760f                 | push                dword ptr [esi + 8]
            //   3998a4000000         | je                  0x1c
            //   7607                 | push                0
            //   57                   | push                0
            //   56                   | push                dword ptr [esi + 8]

        $sequence_17 = { 3b0d???????? 7329 4863d1 488d0dd0ab0000 }
            // n = 4, score = 100
            //   3b0d????????         |                     
            //   7329                 | lea                 ebp, [edx + 0x12]
            //   4863d1               | inc                 ecx
            //   488d0dd0ab0000       | mov                 esi, 4

        $sequence_18 = { ff15???????? 4c8d5c2440 488d1571020100 492bd3 410fb60b 410fb60413 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   4c8d5c2440           | lea                 ecx, [0xabd0]
            //   488d1571020100       | mov                 dword ptr [edi + 0x10], ebx
            //   492bd3               | dec                 eax
            //   410fb60b             | mov                 ecx, dword ptr [edi + 0x18]
            //   410fb60413           | dec                 eax

        $sequence_19 = { c744243004010000 e8???????? 488b4c2438 4c8d5c2430 488d842450010000 488d15f0bd0000 4c895c2428 }
            // n = 7, score = 100
            //   c744243004010000     | mov                 dword ptr [esp + 0x30], 0x104
            //   e8????????           |                     
            //   488b4c2438           | dec                 eax
            //   4c8d5c2430           | mov                 ecx, dword ptr [esp + 0x38]
            //   488d842450010000     | dec                 esp
            //   488d15f0bd0000       | lea                 ebx, [esp + 0x30]
            //   4c895c2428           | dec                 eax

        $sequence_20 = { 8d6a12 41be04000000 4d2be3 0f1f00 448bc2 }
            // n = 5, score = 100
            //   8d6a12               | lea                 eax, [esp + 0x150]
            //   41be04000000         | dec                 eax
            //   4d2be3               | lea                 edx, [0xbdf0]
            //   0f1f00               | dec                 esp
            //   448bc2               | mov                 dword ptr [esp + 0x28], ebx

        $sequence_21 = { 68???????? 8d45f0 50 c745f0f0d12300 e8???????? }
            // n = 5, score = 100
            //   68????????           |                     
            //   8d45f0               | pop                 esi
            //   50                   | pop                 edi
            //   c745f0f0d12300       | pop                 ebx
            //   e8????????           |                     

        $sequence_22 = { 488bcb e8???????? 85ff 7e33 }
            // n = 4, score = 100
            //   488bcb               | cmp                 ebx, edi
            //   e8????????           |                     
            //   85ff                 | jb                  0xfffffff2
            //   7e33                 | je                  0x26

        $sequence_23 = { 8b4310 33c9 56 57 394878 }
            // n = 5, score = 100
            //   8b4310               | push                0
            //   33c9                 | push                dword ptr [esi + 8]
            //   56                   | call                dword ptr [esi + 4]
            //   57                   | push                0x8000
            //   394878               | mov                 eax, edi

        $sequence_24 = { 895f10 488b4f18 4885c9 740c e8???????? }
            // n = 5, score = 100
            //   895f10               | dec                 ebp
            //   488b4f18             | sub                 esp, ebx
            //   4885c9               | nop                 dword ptr [eax]
            //   740c                 | inc                 esp
            //   e8????????           |                     

        $sequence_25 = { 3bf2 7cc1 034004 8b4804 }
            // n = 4, score = 100
            //   3bf2                 | pop                 ebp
            //   7cc1                 | ret                 
            //   034004               | push                8
            //   8b4804               | je                  0x1c

        $sequence_26 = { 4883c308 483bdf 72ed 48833d????????00 741f 488d0dc6ef0000 e8???????? }
            // n = 7, score = 100
            //   4883c308             | mov                 eax, edx
            //   483bdf               | jae                 0x2b
            //   72ed                 | dec                 eax
            //   48833d????????00     |                     
            //   741f                 | arpl                cx, dx
            //   488d0dc6ef0000       | dec                 eax
            //   e8????????           |                     

        $sequence_27 = { 85c0 752c ff7508 68???????? }
            // n = 4, score = 100
            //   85c0                 | push                0
            //   752c                 | push                dword ptr [esi + 8]
            //   ff7508               | push                0
            //   68????????           |                     

    condition:
        7 of them and filesize < 188416
}