rule win_spica_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spica."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spica"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3410f6f9798080000 f3410f6f9fa8080000 660f7f9b20040000 660f7f9310040000 660f7f8b00040000 660f7f83f0030000 41c687a409000001 }
            // n = 7, score = 100
            //   f3410f6f9798080000     | jne    0x231
            //   f3410f6f9fa8080000     | inc    ecx
            //   660f7f9b20040000     | movq                mm1, qword ptr [ecx]
            //   660f7f9310040000     | pcmpeqd             xmm1, xmm0
            //   660f7f8b00040000     | pshufd              xmm0, xmm1, 0xb1
            //   660f7f83f0030000     | pand                xmm0, xmm1
            //   41c687a409000001     | movmskpd            ecx, xmm0

        $sequence_1 = { f30f7f01 e9???????? 4883fe08 488b4c2470 480f42ce 488b5c2430 4829d9 }
            // n = 7, score = 100
            //   f30f7f01             | call                esp
            //   e9????????           |                     
            //   4883fe08             | movdqu              xmmword ptr [eax], xmm0
            //   488b4c2470           | mov                 word ptr [eax + 0x30], 0x5345
            //   480f42ce             | dec                 eax
            //   488b5c2430           | mov                 eax, esi
            //   4829d9               | dec                 ebp

        $sequence_2 = { ff15???????? 4885c0 0f84d9050000 4889c1 488905???????? 41b880000000 31d2 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4885c0               | mov                 ecx, eax
            //   0f84d9050000         | dec                 eax
            //   4889c1               | test                eax, eax
            //   488905????????       |                     
            //   41b880000000         | je                  0x3421
            //   31d2                 | dec                 eax

        $sequence_3 = { eb1b 4d8b8590000000 b800020000 4c234658 b940020000 0f44c1 4533db }
            // n = 7, score = 100
            //   eb1b                 | dec                 eax
            //   4d8b8590000000       | mov                 ecx, edi
            //   b800020000           | dec                 esp
            //   4c234658             | mov                 edi, dword ptr [esp + 0x40]
            //   b940020000           | jmp                 0x1a4
            //   0f44c1               | jmp                 0x1be
            //   4533db               | inc                 ecx

        $sequence_4 = { e8???????? 488d95b0000000 4889d9 e8???????? 440fb7f8 0fb74b58 4189cc }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d95b0000000       | mov                 edx, 0x46
            //   4889d9               | dec                 eax
            //   e8????????           |                     
            //   440fb7f8             | lea                 eax, [0x2220c2]
            //   0fb74b58             | dec                 eax
            //   4189cc               | mov                 dword ptr [ebx + 0x30], 0

        $sequence_5 = { ff5018 4d89fd 84c0 7424 e9???????? 0f854f060000 4c89f1 }
            // n = 7, score = 100
            //   ff5018               | dec                 eax
            //   4d89fd               | lea                 eax, [0x24279b]
            //   84c0                 | dec                 eax
            //   7424                 | mov                 dword ptr [esp + 0x20], eax
            //   e9????????           |                     
            //   0f854f060000         | call                dword ptr [eax + 0x18]
            //   4c89f1               | dec                 eax

        $sequence_6 = { ff15???????? 488b0b 488b93a0000000 4885d2 741b 0fb783c0000000 3bf0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488b0b               | test                eax, eax
            //   488b93a0000000       | dec                 eax
            //   4885d2               | mov                 dword ptr [ebp - 0x20], eax
            //   741b                 | je                  0x1f6
            //   0fb783c0000000       | dec                 eax
            //   3bf0                 | mov                 ecx, esi

        $sequence_7 = { 8b442458 4863cb 448bf3 4903cf 4863e8 48c1e520 ffc3 }
            // n = 7, score = 100
            //   8b442458             | cmp                 eax, 0x2df20da3
            //   4863cb               | je                  0xd1
            //   448bf3               | cmp                 eax, 0x319c2973
            //   4903cf               | jne                 0xdc
            //   4863e8               | dec                 eax
            //   48c1e520             | mov                 ecx, ebx
            //   ffc3                 | mov                 eax, dword ptr [ebx + 0x24]

        $sequence_8 = { ffc7 4983c670 3b7d00 7cab 4c8b742448 488b5c2440 488b6c2450 }
            // n = 7, score = 100
            //   ffc7                 | jne                 0x57
            //   4983c670             | mov                 dword ptr [esp + 0x70], ebp
            //   3b7d00               | mov                 edx, 0x78
            //   7cab                 | dec                 eax
            //   4c8b742448           | mov                 ecx, esi
            //   488b5c2440           | inc                 ebp
            //   488b6c2450           | dec                 eax

        $sequence_9 = { ffc1 f7f1 418bc1 8bcd 442bc2 33d2 41f737 }
            // n = 7, score = 100
            //   ffc1                 | inc                 ecx
            //   f7f1                 | inc                 ecx
            //   418bc1               | cmp                 ecx, eax
            //   8bcd                 | jl                  0x6c6
            //   442bc2               | inc                 ecx
            //   33d2                 | movzx               ecx, sp
            //   41f737               | movsx               eax, cx

    condition:
        7 of them and filesize < 14034944
}