rule win_spider_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spider_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spider_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 493bce 7415 488b01 4d8bc5 ba01000000 ff5020 8bd8 }
            // n = 7, score = 200
            //   493bce               | xor                 ecx, ecx
            //   7415                 | dec                 eax
            //   488b01               | mov                 ebx, eax
            //   4d8bc5               | dec                 eax
            //   ba01000000           | lea                 eax, [0x543f8]
            //   ff5020               | dec                 eax
            //   8bd8                 | test                ebx, ebx

        $sequence_1 = { 833903 b801000000 756e 397104 7569 488b4908 4885c9 }
            // n = 7, score = 200
            //   833903               | mov                 eax, 0x80004005
            //   b801000000           | jmp                 0x722
            //   756e                 | dec                 eax
            //   397104               | mov                 eax, dword ptr [ecx]
            //   7569                 | dec                 esp
            //   488b4908             | lea                 eax, [edi + 0x10]
            //   4885c9               | dec                 eax

        $sequence_2 = { e8???????? cc 488d88c0000000 488d15b2f7ffff e8???????? 8bce 483bc6 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   cc                   | dec                 eax
            //   488d88c0000000       | lea                 eax, [0x1ad55]
            //   488d15b2f7ffff       | ret                 
            //   e8????????           |                     
            //   8bce                 | dec                 eax
            //   483bc6               | mov                 esi, dword ptr [esp + 0x40]

        $sequence_3 = { 7433 488bc8 833904 7517 44396104 7511 }
            // n = 6, score = 200
            //   7433                 | dec                 eax
            //   488bc8               | lea                 edx, [esp + 0x40]
            //   833904               | dec                 eax
            //   7517                 | mov                 eax, dword ptr [edx + 0x10]
            //   44396104             | dec                 ecx
            //   7511                 | mov                 dword ptr [eax + 0x10], eax

        $sequence_4 = { 4c8be8 c64424305c 41b901000000 4983c8ff 488d542430 488bce e8???????? }
            // n = 7, score = 200
            //   4c8be8               | lea                 ecx, [esp + 0x40]
            //   c64424305c           | dec                 eax
            //   41b901000000         | mov                 ebx, dword ptr [esp + 0x40]
            //   4983c8ff             | cmp                 dword ptr [ebx - 0x10], 0
            //   488d542430           | je                  0x228
            //   488bce               | inc                 ecx
            //   e8????????           |                     

        $sequence_5 = { 0fb601 8807 48ffc1 48ffc7 84c0 75f1 49837d2010 }
            // n = 7, score = 200
            //   0fb601               | mov                 esi, edx
            //   8807                 | dec                 eax
            //   48ffc1               | mov                 dword ptr [esp + 0x58], 0xfffffffe
            //   48ffc7               | dec                 eax
            //   84c0                 | mov                 dword ptr [eax + 8], ebx
            //   75f1                 | dec                 ebp
            //   49837d2010           | mov                 esi, ecx

        $sequence_6 = { 4883ec20 488d05df860200 488bf9 488901 4883c118 e8???????? 488b5718 }
            // n = 7, score = 200
            //   4883ec20             | mov                 dword ptr [esp + 0x28], eax
            //   488d05df860200       | jne                 0x2f1
            //   488bf9               | int3                
            //   488901               | dec                 eax
            //   4883c118             | mov                 dword ptr [esp + 0x48], eax
            //   e8????????           |                     
            //   488b5718             | dec                 eax

        $sequence_7 = { 488b4c2440 488d542478 488b01 ff5018 413bc6 8bd8 0f8c4c010000 }
            // n = 7, score = 200
            //   488b4c2440           | dec                 eax
            //   488d542478           | mov                 eax, dword ptr [esp]
            //   488b01               | dec                 eax
            //   ff5018               | mov                 dword ptr [edx - 8], eax
            //   413bc6               | dec                 eax
            //   8bd8                 | lea                 esp, [edx - 8]
            //   0f8c4c010000         | ret                 

        $sequence_8 = { b890900100 e8???????? 482be0 48c7442448feffffff 488b05???????? 4833c4 4889842480900100 }
            // n = 7, score = 200
            //   b890900100           | lea                 ecx, [ebx + 0x88]
            //   e8????????           |                     
            //   482be0               | dec                 eax
            //   48c7442448feffffff     | lea    ecx, [ebx + 0x60]
            //   488b05????????       |                     
            //   4833c4               | nop                 
            //   4889842480900100     | dec                 eax

        $sequence_9 = { 664489442420 4533c9 4c8d05322a0200 418b9424f0000000 ff5030 488b8c2420010000 488b01 }
            // n = 7, score = 200
            //   664489442420         | test                eax, eax
            //   4533c9               | js                  0xfbb
            //   4c8d05322a0200       | dec                 eax
            //   418b9424f0000000     | and                 dword ptr [esp + 0x30], 0
            //   ff5030               | and                 dword ptr [esp + 0x28], 0
            //   488b8c2420010000     | inc                 ecx
            //   488b01               | mov                 eax, 3

    condition:
        7 of them and filesize < 1107968
}