rule win_splitloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.splitloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.splitloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c6817401000043 c681f701000043 488d0524910000 488981b8000000 b90d000000 e8???????? }
            // n = 6, score = 100
            //   c6817401000043       | lea                 ecx, [0x33ec]
            //   c681f701000043       | inc                 ebp
            //   488d0524910000       | xor                 ecx, ecx
            //   488981b8000000       | mov                 edx, 0x40000000
            //   b90d000000           | inc                 esp
            //   e8????????           |                     

        $sequence_1 = { 8bca 418984240cab0000 48014d10 85c0 790a b8fdffffff }
            // n = 6, score = 100
            //   8bca                 | mov                 eax, 0xfffffffd
            //   418984240cab0000     | inc                 ecx
            //   48014d10             | mov                 dword ptr [esp + 0x2af8], eax
            //   85c0                 | inc                 ebp
            //   790a                 | test                ebp, ebp
            //   b8fdffffff           | js                  0x28d

        $sequence_2 = { 8b430c 8905???????? 8bd7 4c8d05f073ffff 89542420 83fa05 }
            // n = 6, score = 100
            //   8b430c               | dec                 eax
            //   8905????????         |                     
            //   8bd7                 | test                ecx, ecx
            //   4c8d05f073ffff       | je                  0x161
            //   89542420             | inc                 ecx
            //   83fa05               | cmp                 ecx, 1

        $sequence_3 = { 488bcf 4889742420 ff15???????? 4533c9 }
            // n = 4, score = 100
            //   488bcf               | sub                 eax, edi
            //   4889742420           | dec                 eax
            //   ff15????????         |                     
            //   4533c9               | lea                 eax, [eax + edx - 1]

        $sequence_4 = { 488be9 41be08000000 4d85e4 750e 418d46f6 4883c460 415e }
            // n = 7, score = 100
            //   488be9               | jbe                 0x19a8
            //   41be08000000         | inc                 esp
            //   4d85e4               | lea                 edx, [edx + 7]
            //   750e                 | nop                 dword ptr [eax]
            //   418d46f6             | movzx               eax, byte ptr [ebx]
            //   4883c460             | inc                 ecx
            //   415e                 | add                 edx, 8

        $sequence_5 = { 48897c2418 4154 4883ec20 4c8d25fc970000 33f6 }
            // n = 5, score = 100
            //   48897c2418           | dec                 eax
            //   4154                 | add                 edi, edi
            //   4883ec20             | dec                 esp
            //   4c8d25fc970000       | lea                 ebp, [0x96a9]
            //   33f6                 | dec                 eax

        $sequence_6 = { 750e 0f1f4000 4883c702 6644391f 74f6 }
            // n = 5, score = 100
            //   750e                 | dec                 eax
            //   0f1f4000             | mov                 ecx, edi
            //   4883c702             | dec                 eax
            //   6644391f             | mov                 dword ptr [esp + 0x20], esi
            //   74f6                 | inc                 ebp

        $sequence_7 = { 8905???????? 8b430c 8905???????? 8bd7 4c8d05f073ffff 89542420 }
            // n = 6, score = 100
            //   8905????????         |                     
            //   8b430c               | dec                 eax
            //   8905????????         |                     
            //   8bd7                 | xor                 eax, esp
            //   4c8d05f073ffff       | dec                 eax
            //   89542420             | mov                 dword ptr [esp + 0x110], eax

        $sequence_8 = { eb9a 488d15df660000 488d0dc0660000 e8???????? 488d15dc660000 }
            // n = 5, score = 100
            //   eb9a                 | mov                 word ptr [ebp + 0x90], si
            //   488d15df660000       | inc                 esp
            //   488d0dc0660000       | mov                 ecx, esi
            //   e8????????           |                     
            //   488d15dc660000       | dec                 eax

        $sequence_9 = { 6644391f 750e 0f1f4000 4883c702 }
            // n = 4, score = 100
            //   6644391f             | sub                 dword ptr [ebp + 8], edx
            //   750e                 | add                 dword ptr [ebp + 0xc], edx
            //   0f1f4000             | mov                 esi, dword ptr [ebp + 0x18]
            //   4883c702             | dec                 eax

    condition:
        7 of them and filesize < 174080
}