rule win_spora_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spora_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spora_ransom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8d45f0 50 ff5508 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   ff5508               | call                dword ptr [ebp + 8]

        $sequence_1 = { 7436 03fb 83ff0c 72ec }
            // n = 4, score = 200
            //   7436                 | je                  0x38
            //   03fb                 | add                 edi, ebx
            //   83ff0c               | cmp                 edi, 0xc
            //   72ec                 | jb                  0xffffffee

        $sequence_2 = { 53 56 ff7508 e8???????? 85c0 7422 56 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7422                 | je                  0x24
            //   56                   | push                esi

        $sequence_3 = { ff36 57 ff15???????? 57 e8???????? }
            // n = 5, score = 200
            //   ff36                 | push                dword ptr [esi]
            //   57                   | push                edi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_4 = { 83fe0a 72e4 5e c9 c3 }
            // n = 5, score = 200
            //   83fe0a               | cmp                 esi, 0xa
            //   72e4                 | jb                  0xffffffe6
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_5 = { 8bf0 85f6 7445 8365fc00 8d45fc 50 57 }
            // n = 7, score = 200
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7445                 | je                  0x47
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_6 = { 8d45f0 50 ff5508 d1eb 46 83fe1a 72c7 }
            // n = 7, score = 200
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   ff5508               | call                dword ptr [ebp + 8]
            //   d1eb                 | shr                 ebx, 1
            //   46                   | inc                 esi
            //   83fe1a               | cmp                 esi, 0x1a
            //   72c7                 | jb                  0xffffffc9

        $sequence_7 = { 740e 8b45fc 8b4010 0fb6f0 }
            // n = 4, score = 200
            //   740e                 | je                  0x10
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   0fb6f0               | movzx               esi, al

        $sequence_8 = { 0bf0 57 ff15???????? 5f 8bc6 }
            // n = 5, score = 200
            //   0bf0                 | or                  esi, eax
            //   57                   | push                edi
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_9 = { 741f ff36 ff15???????? 85c0 7413 0fb600 }
            // n = 6, score = 200
            //   741f                 | je                  0x21
            //   ff36                 | push                dword ptr [esi]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   0fb600               | movzx               eax, byte ptr [eax]

    condition:
        7 of them and filesize < 73728
}