rule win_spyder_patchwork_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spyder_patchwork."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spyder_patchwork"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3930 0f8551010000 8b4004 83f82a 7429 83f839 7424 }
            // n = 7, score = 100
            //   3930                 | cmp                 dword ptr [eax], esi
            //   0f8551010000         | jne                 0x157
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   83f82a               | cmp                 eax, 0x2a
            //   7429                 | je                  0x2b
            //   83f839               | cmp                 eax, 0x39
            //   7424                 | je                  0x26

        $sequence_1 = { ff74246c 50 e8???????? 83c410 5f 5e 5b }
            // n = 7, score = 100
            //   ff74246c             | push                dword ptr [esp + 0x6c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_2 = { 8904a9 8b4c2444 8b44241c c1e002 0101 8b4c2458 8b442430 }
            // n = 7, score = 100
            //   8904a9               | mov                 dword ptr [ecx + ebp*4], eax
            //   8b4c2444             | mov                 ecx, dword ptr [esp + 0x44]
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   c1e002               | shl                 eax, 2
            //   0101                 | add                 dword ptr [ecx], eax
            //   8b4c2458             | mov                 ecx, dword ptr [esp + 0x58]
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]

        $sequence_3 = { e9???????? 6800030000 8d44242c 50 6a07 6801990000 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   6800030000           | push                0x300
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   50                   | push                eax
            //   6a07                 | push                7
            //   6801990000           | push                0x9901
            //   e8????????           |                     

        $sequence_4 = { 743c ba80000000 be00080000 0f1f8000000000 0fb60419 0fb70445403b4400 }
            // n = 6, score = 100
            //   743c                 | je                  0x3e
            //   ba80000000           | mov                 edx, 0x80
            //   be00080000           | mov                 esi, 0x800
            //   0f1f8000000000       | nop                 dword ptr [eax]
            //   0fb60419             | movzx               eax, byte ptr [ecx + ebx]
            //   0fb70445403b4400     | movzx               eax, word ptr [eax*2 + 0x443b40]

        $sequence_5 = { e8???????? ff7620 e8???????? 56 e8???????? 83c420 5f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ff7620               | push                dword ptr [esi + 0x20]
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   5f                   | pop                 edi

        $sequence_6 = { 741f 8b542410 3bca 7617 8b4608 2bca 51 }
            // n = 7, score = 100
            //   741f                 | je                  0x21
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   3bca                 | cmp                 ecx, edx
            //   7617                 | jbe                 0x19
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   2bca                 | sub                 ecx, edx
            //   51                   | push                ecx

        $sequence_7 = { 8b4c242c 8d04b0 8b28 4e ba02000000 894c2414 89442420 }
            // n = 7, score = 100
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   8d04b0               | lea                 eax, [eax + esi*4]
            //   8b28                 | mov                 ebp, dword ptr [eax]
            //   4e                   | dec                 esi
            //   ba02000000           | mov                 edx, 2
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   89442420             | mov                 dword ptr [esp + 0x20], eax

        $sequence_8 = { 6689460c 8b0f 8bc1 83e002 83c800 741d 668b4648 }
            // n = 7, score = 100
            //   6689460c             | mov                 word ptr [esi + 0xc], ax
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   8bc1                 | mov                 eax, ecx
            //   83e002               | and                 eax, 2
            //   83c800               | or                  eax, 0
            //   741d                 | je                  0x1f
            //   668b4648             | mov                 ax, word ptr [esi + 0x48]

        $sequence_9 = { ff15???????? 6a06 6a00 ff15???????? 6a00 6a00 6a00 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   6a06                 | push                6
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 2260992
}