rule win_spyeye_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spyeye."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spyeye"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740e 837dfcff 7408 ff75fc }
            // n = 4, score = 700
            //   740e                 | je                  0x10
            //   837dfcff             | cmp                 dword ptr [ebp - 4], -1
            //   7408                 | je                  0xa
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_1 = { 8b65fc c9 c20800 55 8bec }
            // n = 5, score = 700
            //   8b65fc               | mov                 esp, dword ptr [ebp - 4]
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_2 = { 56 6880000000 6a04 56 6a07 6800000040 57 }
            // n = 7, score = 700
            //   56                   | push                esi
            //   6880000000           | push                0x80
            //   6a04                 | push                4
            //   56                   | push                esi
            //   6a07                 | push                7
            //   6800000040           | push                0x40000000
            //   57                   | push                edi

        $sequence_3 = { ff7508 ffd0 8b65fc c9 c21400 55 8bec }
            // n = 7, score = 700
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax
            //   8b65fc               | mov                 esp, dword ptr [ebp - 4]
            //   c9                   | leave               
            //   c21400               | ret                 0x14
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_4 = { ff750c e8???????? 8bd8 83fbff 751b 57 }
            // n = 6, score = 700
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   83fbff               | cmp                 ebx, -1
            //   751b                 | jne                 0x1d
            //   57                   | push                edi

        $sequence_5 = { 837dfcff 7408 ff75fc e8???????? 3bdf }
            // n = 5, score = 700
            //   837dfcff             | cmp                 dword ptr [ebp - 4], -1
            //   7408                 | je                  0xa
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   3bdf                 | cmp                 ebx, edi

        $sequence_6 = { 740a 83e0fe 50 57 }
            // n = 4, score = 700
            //   740a                 | je                  0xc
            //   83e0fe               | and                 eax, 0xfffffffe
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_7 = { 6a02 eb08 56 6880000000 6a04 }
            // n = 5, score = 700
            //   6a02                 | push                2
            //   eb08                 | jmp                 0xa
            //   56                   | push                esi
            //   6880000000           | push                0x80
            //   6a04                 | push                4

        $sequence_8 = { 6a03 57 6a01 56 ff750c e8???????? }
            // n = 6, score = 700
            //   6a03                 | push                3
            //   57                   | push                edi
            //   6a01                 | push                1
            //   56                   | push                esi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     

        $sequence_9 = { 50 e8???????? 85c0 7454 57 56 }
            // n = 6, score = 700
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7454                 | je                  0x56
            //   57                   | push                edi
            //   56                   | push                esi

    condition:
        7 of them and filesize < 741376
}