rule win_spygrace_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spygrace."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spygrace"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 742a 488bc5 4c8d05d90c0300 488bcd 48c1f906 83e03f }
            // n = 7, score = 100
            //   85c0                 | psrldq              xmm0, 8
            //   742a                 | dec                 ebp
            //   488bc5               | mov                 eax, dword ptr [esp]
            //   4c8d05d90c0300       | movzx               ecx, byte ptr [esp + eax + 0x20]
            //   488bcd               | inc                 edx
            //   48c1f906             | movzx               eax, byte ptr [esp + ecx + 0x20]
            //   83e03f               | dec                 eax

        $sequence_1 = { 488bc3 48397b18 7203 488b03 48894c2430 4889442428 48c744242013000000 }
            // n = 7, score = 100
            //   488bc3               | mov                 dword ptr [ebp - 0x10], eax
            //   48397b18             | dec                 eax
            //   7203                 | mov                 dword ptr [ebp - 0x28], eax
            //   488b03               | dec                 esp
            //   48894c2430           | mov                 dword ptr [ebp - 0x20], ebp
            //   4889442428           | movdqu              xmmword ptr [ebp - 0x10], xmm0
            //   48c744242013000000     | inc    esp

        $sequence_2 = { bb01000000 4533e4 448d4b5b 6644394c48fe 7440 483bca 731c }
            // n = 7, score = 100
            //   bb01000000           | mov                 edx, dword ptr [edx]
            //   4533e4               | dec                 eax
            //   448d4b5b             | mov                 ecx, ebx
            //   6644394c48fe         | dec                 eax
            //   7440                 | lea                 edx, [ebx + 0x2c8]
            //   483bca               | dec                 eax
            //   731c                 | cmp                 dword ptr [edx + 0x18], 8

        $sequence_3 = { 488d4db0 48837dc808 480f434db0 ffd2 85c0 0f85b0010000 4d8d86a0020000 }
            // n = 7, score = 100
            //   488d4db0             | add                 ecx, 0x220
            //   48837dc808           | dec                 eax
            //   480f434db0           | mov                 ecx, dword ptr [edx + 0x30]
            //   ffd2                 | dec                 eax
            //   85c0                 | add                 ecx, 0x240
            //   0f85b0010000         | dec                 eax
            //   4d8d86a0020000       | mov                 ecx, dword ptr [edx + 0x30]

        $sequence_4 = { 490f42c0 488d4dd0 48837de808 480f434dd0 4c2bc0 4c8945e0 4e8d044502000000 }
            // n = 7, score = 100
            //   490f42c0             | jbe                 0x683
            //   488d4dd0             | dec                 eax
            //   48837de808           | mov                 dword ptr [esp + 0x28], edi
            //   480f434dd0           | dec                 eax
            //   4c2bc0               | mov                 edx, ecx
            //   4c8945e0             | dec                 ecx
            //   4e8d044502000000     | mov                 dword ptr [ebx - 0x10], eax

        $sequence_5 = { 488d4d1f e8???????? 90 488b4b10 48b8ffffffffffffff7f 482bc1 4883f807 }
            // n = 7, score = 100
            //   488d4d1f             | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 ebx, dword ptr [esp + 0x30]
            //   488b4b10             | dec                 eax
            //   48b8ffffffffffffff7f     | add    esp, 0x20
            //   482bc1               | pop                 edi
            //   4883f807             | ret                 

        $sequence_6 = { 4c8b4110 488bf1 4d85c0 b901000000 490f45c8 488be9 }
            // n = 6, score = 100
            //   4c8b4110             | dec                 esp
            //   488bf1               | mov                 dword ptr [esp + 0x58], esp
            //   4d85c0               | dec                 esp
            //   b901000000           | mov                 dword ptr [esp + 0x60], esp
            //   490f45c8             | dec                 eax
            //   488be9               | lea                 edx, [ebp + 0x10]

        $sequence_7 = { e8???????? e9???????? 49638dd0330000 e8???????? 4889442448 498bce be10000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   49638dd0330000       | dec                 eax
            //   e8????????           |                     
            //   4889442448           | and                 dword ptr [ebp - 0x30], 0
            //   498bce               | dec                 eax
            //   be10000000           | and                 dword ptr [ebp - 0x20], 0

        $sequence_8 = { 488d05bbc60200 4889442460 488d05c7c60200 4889442468 488d05cbc60200 4889442470 488d05cfc60200 }
            // n = 7, score = 100
            //   488d05bbc60200       | cmp                 dword ptr [edx + 0x18], ebp
            //   4889442460           | jb                  0x47f
            //   488d05c7c60200       | dec                 eax
            //   4889442468           | mov                 edx, dword ptr [edx]
            //   488d05cbc60200       | dec                 eax
            //   4889442470           | mov                 edx, dword ptr [edx]
            //   488d05cfc60200       | dec                 eax

        $sequence_9 = { 498bc8 e8???????? 4883a31004000000 488bcb 48c783180400000f000000 c6830004000000 4883c420 }
            // n = 7, score = 100
            //   498bc8               | dec                 eax
            //   e8????????           |                     
            //   4883a31004000000     | lea                 eax, [0x2c725]
            //   488bcb               | dec                 eax
            //   48c783180400000f000000     | lea    eax, [0x33b0f]
            //   c6830004000000       | jmp                 0x147
            //   4883c420             | dec                 eax

    condition:
        7 of them and filesize < 865280
}