rule win_squidloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.squidloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.squidloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f114c2440 0f114c2450 0f114c2460 0f114c2470 }
            // n = 4, score = 200
            //   0f114c2440           | cmp                 dword ptr [edi], 3
            //   0f114c2450           | jne                 0xc96
            //   0f114c2460           | movups              xmmword ptr [eax + 4], xmm0
            //   0f114c2470           | dec                 eax

        $sequence_1 = { 5f 5e c3 4053 4883ec30 488bd9 8b4934 }
            // n = 7, score = 200
            //   5f                   | inc                 ebx
            //   5e                   | movups              xmm4, xmmword ptr [esi + ecx*8]
            //   c3                   | subps               xmm3, xmm4
            //   4053                 | movaps              xmm4, xmm3
            //   4883ec30             | shufps              xmm4, xmm3, 0x55
            //   488bd9               | dec                 esp
            //   8b4934               | mov                 ebx, dword ptr [esp + 0xb8]

        $sequence_2 = { c3 4053 4883ec30 488bd9 8b4934 83e902 }
            // n = 6, score = 200
            //   c3                   | mov                 ecx, edi
            //   4053                 | mov                 dword ptr [esp + 0x28], eax
            //   4883ec30             | dec                 esp
            //   488bd9               | mov                 dword ptr [esp + 0x20], esi
            //   8b4934               | dec                 eax
            //   83e902               | lea                 ecx, [esp + 0x60]

        $sequence_3 = { 57 4881ec90000000 488b05???????? 4833c4 4889842480000000 488bda 488bf9 }
            // n = 7, score = 200
            //   57                   | mov                 dword ptr [esp + 0x60], esi
            //   4881ec90000000       | test                edi, edi
            //   488b05????????       |                     
            //   4833c4               | dec                 esp
            //   4889842480000000     | mov                 ecx, edi
            //   488bda               | dec                 ecx
            //   488bf9               | mov                 edi, eax

        $sequence_4 = { 5e c3 4053 4883ec30 488bd9 8b4934 }
            // n = 6, score = 200
            //   5e                   | mulss               xmm5, xmm0
            //   c3                   | dec                 esp
            //   4053                 | mov                 esi, eax
            //   4883ec30             | movss               xmm0, dword ptr [esp + 0x70]
            //   488bd9               | dec                 eax
            //   8b4934               | xor                 eax, esp

        $sequence_5 = { c3 4053 4883ec30 488bd9 8b4934 83e902 746a }
            // n = 7, score = 200
            //   c3                   | mov                 ecx, esi
            //   4053                 | dec                 eax
            //   4883ec30             | mov                 edx, dword ptr [esp + 0x48]
            //   488bd9               | dec                 esp
            //   8b4934               | mov                 edi, dword ptr [esp + 0x40]
            //   83e902               | dec                 ebp
            //   746a                 | mov                 eax, edi

        $sequence_6 = { c3 4053 4883ec30 488bd9 8b4934 }
            // n = 5, score = 200
            //   c3                   | dec                 eax
            //   4053                 | mov                 ecx, dword ptr [edi + 0x20]
            //   4883ec30             | dec                 eax
            //   488bd9               | cmp                 dword ptr [ecx + 0x50], 0
            //   8b4934               | jne                 0x288

        $sequence_7 = { 5e c3 4053 4883ec30 488bd9 8b4934 83e902 }
            // n = 7, score = 200
            //   5e                   | not                 byte ptr [eax + ecx + 2]
            //   c3                   | dec                 esp
            //   4053                 | mov                 eax, dword ptr [edi + 0xb8]
            //   4883ec30             | dec                 esp
            //   488bd9               | mov                 eax, dword ptr [edi + 0xb8]
            //   8b4934               | inc                 ecx
            //   83e902               | not                 byte ptr [eax + ecx + 1]

        $sequence_8 = { ffd3 48837c242800 0f84ae000000 b8ffffffff f00fc105???????? 85c0 7f0c }
            // n = 7, score = 100
            //   ffd3                 | addss               xmm1, xmm2
            //   48837c242800         | addss               xmm0, xmm3
            //   0f84ae000000         | inc                 esp
            //   b8ffffffff           | cvtps2pd            xmm0, xmm0
            //   f00fc105????????     |                     
            //   85c0                 | inc                 esp
            //   7f0c                 | cvtps2pd            xmm4, xmm3

        $sequence_9 = { e8???????? f30f108424a0010000 f30f108c24a4010000 e8???????? f20f108c2420010000 0f16d1 0fc6c000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   f30f108424a0010000     | mov    byte ptr [esi + 0x20], 1
            //   f30f108c24a4010000     | dec    eax
            //   e8????????           |                     
            //   f20f108c2420010000     | mov    dword ptr [esi + 8], ecx
            //   0f16d1               | dec                 eax
            //   0fc6c000             | mov                 eax, esi

    condition:
        7 of them and filesize < 18701312
}