rule win_squirrelwaffle_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.squirrelwaffle."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.squirrelwaffle"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f44ca 51 e8???????? 8b8690010000 47 }
            // n = 5, score = 700
            //   0f44ca               | cmove               ecx, edx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b8690010000         | mov                 eax, dword ptr [esi + 0x190]
            //   47                   | inc                 edi

        $sequence_1 = { c645fc03 8d55cc 837de010 8b4b10 }
            // n = 4, score = 700
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8d55cc               | lea                 edx, [ebp - 0x34]
            //   837de010             | cmp                 dword ptr [ebp - 0x20], 0x10
            //   8b4b10               | mov                 ecx, dword ptr [ebx + 0x10]

        $sequence_2 = { 83c408 68???????? 6a14 6a18 }
            // n = 4, score = 700
            //   83c408               | add                 esp, 8
            //   68????????           |                     
            //   6a14                 | push                0x14
            //   6a18                 | push                0x18

        $sequence_3 = { 40 84c9 75f9 2bc7 8d4db8 50 }
            // n = 6, score = 700
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bc7                 | sub                 eax, edi
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   50                   | push                eax

        $sequence_4 = { 50 52 e8???????? 83c40c 8d7b40 ff734c ff15???????? }
            // n = 7, score = 700
            //   50                   | push                eax
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d7b40               | lea                 edi, [ebx + 0x40]
            //   ff734c               | push                dword ptr [ebx + 0x4c]
            //   ff15????????         |                     

        $sequence_5 = { 8d45ed c7855cf7ffff00000000 c78560f7ffff0f000000 c6854cf7ffff00 3bf0 740f 2bc6 }
            // n = 7, score = 700
            //   8d45ed               | lea                 eax, [ebp - 0x13]
            //   c7855cf7ffff00000000     | mov    dword ptr [ebp - 0x8a4], 0
            //   c78560f7ffff0f000000     | mov    dword ptr [ebp - 0x8a0], 0xf
            //   c6854cf7ffff00       | mov                 byte ptr [ebp - 0x8b4], 0
            //   3bf0                 | cmp                 esi, eax
            //   740f                 | je                  0x11
            //   2bc6                 | sub                 eax, esi

        $sequence_6 = { 0f46c2 50 e8???????? 83c404 85c0 0f848c000000 8d7023 }
            // n = 7, score = 700
            //   0f46c2               | cmovbe              eax, edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f848c000000         | je                  0x92
            //   8d7023               | lea                 esi, [eax + 0x23]

        $sequence_7 = { 2bc2 3bc1 0f82d4000000 837f1410 7202 }
            // n = 5, score = 700
            //   2bc2                 | sub                 eax, edx
            //   3bc1                 | cmp                 eax, ecx
            //   0f82d4000000         | jb                  0xda
            //   837f1410             | cmp                 dword ptr [edi + 0x14], 0x10
            //   7202                 | jb                  4

        $sequence_8 = { 50 8b4508 50 03c1 }
            // n = 4, score = 700
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   03c1                 | add                 eax, ecx

        $sequence_9 = { 837de010 8b4b10 8b75cc 0f43d6 }
            // n = 4, score = 700
            //   837de010             | cmp                 dword ptr [ebp - 0x20], 0x10
            //   8b4b10               | mov                 ecx, dword ptr [ebx + 0x10]
            //   8b75cc               | mov                 esi, dword ptr [ebp - 0x34]
            //   0f43d6               | cmovae              edx, esi

    condition:
        7 of them and filesize < 147456
}