rule win_sslmm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sslmm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sslmm"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 50 51 8bcb e8???????? 85c0 0f854d010000 }
            // n = 7, score = 400
            //   55                   | push                ebp
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f854d010000         | jne                 0x153

        $sequence_1 = { 51 03ee 55 50 e8???????? 8b442478 }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   03ee                 | add                 ebp, esi
            //   55                   | push                ebp
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b442478             | mov                 eax, dword ptr [esp + 0x78]

        $sequence_2 = { 8bca 83e103 f3aa 8b842480000000 8b4c2420 2bc6 }
            // n = 6, score = 400
            //   8bca                 | mov                 ecx, edx
            //   83e103               | and                 ecx, 3
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   8b842480000000       | mov                 eax, dword ptr [esp + 0x80]
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   2bc6                 | sub                 eax, esi

        $sequence_3 = { 5b 81c45c020000 c3 8b1d???????? 68???????? 56 }
            // n = 6, score = 400
            //   5b                   | pop                 ebx
            //   81c45c020000         | add                 esp, 0x25c
            //   c3                   | ret                 
            //   8b1d????????         |                     
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_4 = { 81ecc8000000 53 8bd9 8b8c24d8000000 55 }
            // n = 5, score = 400
            //   81ecc8000000         | sub                 esp, 0xc8
            //   53                   | push                ebx
            //   8bd9                 | mov                 ebx, ecx
            //   8b8c24d8000000       | mov                 ecx, dword ptr [esp + 0xd8]
            //   55                   | push                ebp

        $sequence_5 = { 51 6a00 8d93dc000000 50 52 }
            // n = 5, score = 400
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   8d93dc000000         | lea                 edx, [ebx + 0xdc]
            //   50                   | push                eax
            //   52                   | push                edx

        $sequence_6 = { 33c0 5e 81c4ac010000 c21000 }
            // n = 4, score = 400
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   81c4ac010000         | add                 esp, 0x1ac
            //   c21000               | ret                 0x10

        $sequence_7 = { ff5204 33c0 5e c20c00 6a00 }
            // n = 5, score = 400
            //   ff5204               | call                dword ptr [edx + 4]
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   c20c00               | ret                 0xc
            //   6a00                 | push                0

        $sequence_8 = { 68c8000000 8bf1 6a00 ffd7 8b1d???????? }
            // n = 5, score = 400
            //   68c8000000           | push                0xc8
            //   8bf1                 | mov                 esi, ecx
            //   6a00                 | push                0
            //   ffd7                 | call                edi
            //   8b1d????????         |                     

        $sequence_9 = { 83c404 40 50 53 6aff 57 6a00 }
            // n = 7, score = 400
            //   83c404               | add                 esp, 4
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   53                   | push                ebx
            //   6aff                 | push                -1
            //   57                   | push                edi
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 188416
}