rule win_ssload_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ssload."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ssload"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894dd4 51 8945e0 ff10 83c404 }
            // n = 5, score = 400
            //   894dd4               | mov                 dword ptr [ebp - 0x2c], ecx
            //   51                   | push                ecx
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   ff10                 | call                dword ptr [eax]
            //   83c404               | add                 esp, 4

        $sequence_1 = { f7e1 c1ea03 8d0492 8d0442 }
            // n = 4, score = 400
            //   f7e1                 | mul                 ecx
            //   c1ea03               | shr                 edx, 3
            //   8d0492               | lea                 eax, [edx + edx*4]
            //   8d0442               | lea                 eax, [edx + eax*2]

        $sequence_2 = { 50 e8???????? 83c40c 01de 89770c e9???????? 8b770c }
            // n = 7, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   01de                 | add                 esi, ebx
            //   89770c               | mov                 dword ptr [edi + 0xc], esi
            //   e9????????           |                     
            //   8b770c               | mov                 esi, dword ptr [edi + 0xc]

        $sequence_3 = { 85f6 b8ffffffff 0f48f8 81ff01020000 }
            // n = 4, score = 400
            //   85f6                 | test                esi, esi
            //   b8ffffffff           | mov                 eax, 0xffffffff
            //   0f48f8               | cmovs               edi, eax
            //   81ff01020000         | cmp                 edi, 0x201

        $sequence_4 = { c745d002000000 648b0d00000000 894de8 64a300000000 }
            // n = 4, score = 400
            //   c745d002000000       | mov                 dword ptr [ebp - 0x30], 2
            //   648b0d00000000       | mov                 ecx, dword ptr fs:[0]
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   64a300000000         | mov                 dword ptr fs:[0], eax

        $sequence_5 = { 0fb6f0 83fe0c 7e0c 83fe1f 7e14 83fe20 7418 }
            // n = 7, score = 300
            //   0fb6f0               | movzx               esi, al
            //   83fe0c               | cmp                 esi, 0xc
            //   7e0c                 | jle                 0xe
            //   83fe1f               | cmp                 esi, 0x1f
            //   7e14                 | jle                 0x16
            //   83fe20               | cmp                 esi, 0x20
            //   7418                 | je                  0x1a

        $sequence_6 = { 89d5 57 53 52 e8???????? 83c40c }
            // n = 6, score = 300
            //   89d5                 | mov                 ebp, edx
            //   57                   | push                edi
            //   53                   | push                ebx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_7 = { 56 83ec2c 8b5c2444 8b6c2440 }
            // n = 4, score = 300
            //   56                   | push                esi
            //   83ec2c               | sub                 esp, 0x2c
            //   8b5c2444             | mov                 ebx, dword ptr [esp + 0x44]
            //   8b6c2440             | mov                 ebp, dword ptr [esp + 0x40]

        $sequence_8 = { 0f57c0 0f1144240c 894c2408 89442404 }
            // n = 4, score = 300
            //   0f57c0               | xorps               xmm0, xmm0
            //   0f1144240c           | movups              xmmword ptr [esp + 0xc], xmm0
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   89442404             | mov                 dword ptr [esp + 4], eax

        $sequence_9 = { 83ec0c 8db53cffffff 8baeb0000000 8b4608 }
            // n = 4, score = 300
            //   83ec0c               | sub                 esp, 0xc
            //   8db53cffffff         | lea                 esi, [ebp - 0xc4]
            //   8baeb0000000         | mov                 ebp, dword ptr [esi + 0xb0]
            //   8b4608               | mov                 eax, dword ptr [esi + 8]

        $sequence_10 = { 83c40c 037de0 8b55d8 39d7 }
            // n = 4, score = 300
            //   83c40c               | add                 esp, 0xc
            //   037de0               | add                 edi, dword ptr [ebp - 0x20]
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   39d7                 | cmp                 edi, edx

        $sequence_11 = { 0345e8 2b45d4 8945dc e9???????? }
            // n = 4, score = 200
            //   0345e8               | add                 eax, dword ptr [ebp - 0x18]
            //   2b45d4               | sub                 eax, dword ptr [ebp - 0x2c]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   e9????????           |                     

        $sequence_12 = { 034828 8b55fc 894a2c eb0a }
            // n = 4, score = 200
            //   034828               | add                 ecx, dword ptr [eax + 0x28]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   894a2c               | mov                 dword ptr [edx + 0x2c], ecx
            //   eb0a                 | jmp                 0xc

        $sequence_13 = { 034228 8945c4 6a00 6a01 6800000010 }
            // n = 5, score = 200
            //   034228               | add                 eax, dword ptr [edx + 0x28]
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6800000010           | push                0x10000000

        $sequence_14 = { 034a10 894de0 8b45e0 3b45dc 7606 8b4de0 894ddc }
            // n = 7, score = 200
            //   034a10               | add                 ecx, dword ptr [edx + 0x10]
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   3b45dc               | cmp                 eax, dword ptr [ebp - 0x24]
            //   7606                 | jbe                 8
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx

        $sequence_15 = { ffd1 83c408 ebbc 8b55fc 8b4208 50 e8???????? }
            // n = 7, score = 200
            //   ffd1                 | call                ecx
            //   83c408               | add                 esp, 8
            //   ebbc                 | jmp                 0xffffffbe
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_16 = { 034214 50 8b4df8 51 e8???????? }
            // n = 5, score = 200
            //   034214               | add                 eax, dword ptr [edx + 0x14]
            //   50                   | push                eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_17 = { 03420c 50 ff15???????? 8945f8 837df800 }
            // n = 5, score = 200
            //   03420c               | add                 eax, dword ptr [edx + 0xc]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0

        $sequence_18 = { 034110 50 8b550c 52 8b4de8 e8???????? }
            // n = 6, score = 200
            //   034110               | add                 eax, dword ptr [ecx + 0x10]
            //   50                   | push                eax
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   52                   | push                edx
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 4950016
}