rule win_starcruft_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.starcruft."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.starcruft"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c 8b45ec 50 e8???????? 83c404 8b4de8 894dec }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx

        $sequence_1 = { 85c0 7505 83c8ff eb17 6a00 8b55ec }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb17                 | jmp                 0x19
            //   6a00                 | push                0
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]

        $sequence_2 = { ff15???????? 8945e4 837de400 740c e8???????? }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   837de400             | cmp                 dword ptr [ebp - 0x1c], 0
            //   740c                 | je                  0xe
            //   e8????????           |                     

        $sequence_3 = { 8d4dfc 51 8d95f0f9ffff 52 6a13 8d8538fbffff }
            // n = 6, score = 100
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   8d95f0f9ffff         | lea                 edx, [ebp - 0x610]
            //   52                   | push                edx
            //   6a13                 | push                0x13
            //   8d8538fbffff         | lea                 eax, [ebp - 0x4c8]

        $sequence_4 = { 8955fc 8b45f8 8945f0 eb09 8b4df0 83c102 }
            // n = 6, score = 100
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   eb09                 | jmp                 0xb
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c102               | add                 ecx, 2

        $sequence_5 = { 83c408 83f8ff 7516 6a00 8d95c8fcffff 52 8d85d0fdffff }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   83f8ff               | cmp                 eax, -1
            //   7516                 | jne                 0x18
            //   6a00                 | push                0
            //   8d95c8fcffff         | lea                 edx, [ebp - 0x338]
            //   52                   | push                edx
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]

        $sequence_6 = { 6a36 8b4d08 83c158 51 e8???????? 83c40c 6a40 }
            // n = 7, score = 100
            //   6a36                 | push                0x36
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c158               | add                 ecx, 0x58
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a40                 | push                0x40

        $sequence_7 = { e9???????? 6a00 8b95e4f5ffff 52 ff15???????? 8b4d10 8901 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   6a00                 | push                0
            //   8b95e4f5ffff         | mov                 edx, dword ptr [ebp - 0xa1c]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_8 = { 8d95f0feffff 52 e8???????? 83c40c 6804010000 8d85ecfdffff 50 }
            // n = 7, score = 100
            //   8d95f0feffff         | lea                 edx, [ebp - 0x110]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6804010000           | push                0x104
            //   8d85ecfdffff         | lea                 eax, [ebp - 0x214]
            //   50                   | push                eax

        $sequence_9 = { 6a06 8d9578fbffff 52 e8???????? 83c410 8d85d0fbffff 50 }
            // n = 7, score = 100
            //   6a06                 | push                6
            //   8d9578fbffff         | lea                 edx, [ebp - 0x488]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d85d0fbffff         | lea                 eax, [ebp - 0x430]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 294912
}