rule win_startpage_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.startpage."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.startpage"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6801000080 ff15???????? 8b4dd8 8bf0 83c1f0 e8???????? 85f6 }
            // n = 7, score = 200
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   8bf0                 | mov                 esi, eax
            //   83c1f0               | add                 ecx, -0x10
            //   e8????????           |                     
            //   85f6                 | test                esi, esi

        $sequence_1 = { 8b4f18 84040a eb57 8b471c 85c0 741b 8b4808 }
            // n = 7, score = 200
            //   8b4f18               | mov                 ecx, dword ptr [edi + 0x18]
            //   84040a               | test                byte ptr [edx + ecx], al
            //   eb57                 | jmp                 0x59
            //   8b471c               | mov                 eax, dword ptr [edi + 0x1c]
            //   85c0                 | test                eax, eax
            //   741b                 | je                  0x1d
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]

        $sequence_2 = { 663bc3 75f6 2b8de4deffff d1f9 41 8d344e 8d144a }
            // n = 7, score = 200
            //   663bc3               | cmp                 ax, bx
            //   75f6                 | jne                 0xfffffff8
            //   2b8de4deffff         | sub                 ecx, dword ptr [ebp - 0x211c]
            //   d1f9                 | sar                 ecx, 1
            //   41                   | inc                 ecx
            //   8d344e               | lea                 esi, [esi + ecx*2]
            //   8d144a               | lea                 edx, [edx + ecx*2]

        $sequence_3 = { 1bc0 2516020780 e9???????? 56 8b36 e8???????? 59 }
            // n = 7, score = 200
            //   1bc0                 | sbb                 eax, eax
            //   2516020780           | and                 eax, 0x80070216
            //   e9????????           |                     
            //   56                   | push                esi
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_4 = { 50 8d4e0c e8???????? 33c0 894610 894614 894618 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d4e0c               | lea                 ecx, [esi + 0xc]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   894610               | mov                 dword ptr [esi + 0x10], eax
            //   894614               | mov                 dword ptr [esi + 0x14], eax
            //   894618               | mov                 dword ptr [esi + 0x18], eax

        $sequence_5 = { 8d7010 89b5e0feffff 8d85e0feffff c645fc0d 50 8d4b1c e8???????? }
            // n = 7, score = 200
            //   8d7010               | lea                 esi, [eax + 0x10]
            //   89b5e0feffff         | mov                 dword ptr [ebp - 0x120], esi
            //   8d85e0feffff         | lea                 eax, [ebp - 0x120]
            //   c645fc0d             | mov                 byte ptr [ebp - 4], 0xd
            //   50                   | push                eax
            //   8d4b1c               | lea                 ecx, [ebx + 0x1c]
            //   e8????????           |                     

        $sequence_6 = { 85c0 51 0f45d8 c645fc05 53 8d4db8 e8???????? }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   51                   | push                ecx
            //   0f45d8               | cmovne              ebx, eax
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   53                   | push                ebx
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e8????????           |                     

        $sequence_7 = { ff15???????? 6a01 ff758c ff15???????? 8b4588 6a15 8b484c }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   ff758c               | push                dword ptr [ebp - 0x74]
            //   ff15????????         |                     
            //   8b4588               | mov                 eax, dword ptr [ebp - 0x78]
            //   6a15                 | push                0x15
            //   8b484c               | mov                 ecx, dword ptr [eax + 0x4c]

        $sequence_8 = { 7417 56 8b30 50 e8???????? 8bc6 59 }
            // n = 7, score = 200
            //   7417                 | je                  0x19
            //   56                   | push                esi
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   59                   | pop                 ecx

        $sequence_9 = { 5b 8be5 5d c3 ff15???????? 0fb7c8 81c900000780 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   ff15????????         |                     
            //   0fb7c8               | movzx               ecx, ax
            //   81c900000780         | or                  ecx, 0x80070000

    condition:
        7 of them and filesize < 2277376
}