rule win_statc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.statc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.statc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7409 8984248c000000 ebc5 488d942488000000 488bcf e8???????? }
            // n = 7, score = 100
            //   85c0                 | dec                 eax
            //   7409                 | mov                 edi, edx
            //   8984248c000000       | dec                 eax
            //   ebc5                 | mov                 ebx, dword ptr [ecx]
            //   488d942488000000     | dec                 eax
            //   488bcf               | mov                 esi, ecx
            //   e8????????           |                     

        $sequence_1 = { c6040129 e9???????? 4d8b4010 488d15c9dd2700 488d4def 4d8b00 e8???????? }
            // n = 7, score = 100
            //   c6040129             | inc                 esp
            //   e9????????           |                     
            //   4d8b4010             | mov                 byte ptr [eax + ecx*8 + 1], ah
            //   488d15c9dd2700       | inc                 ecx
            //   488d4def             | mov                 eax, 1
            //   4d8b00               | inc                 ecx
            //   e8????????           |                     

        $sequence_2 = { 7f1d 8b8424e0000000 448bca ba69000000 89442420 488bcb e8???????? }
            // n = 7, score = 100
            //   7f1d                 | cmp                 dword ptr [ecx + 0x3c], 0
            //   8b8424e0000000       | dec                 eax
            //   448bca               | mov                 ebx, ecx
            //   ba69000000           | jbe                 0x1b1
            //   89442420             | xor                 eax, eax
            //   488bcb               | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { b807000000 8bc8 894344 488bcb 8bd0 e8???????? e9???????? }
            // n = 7, score = 100
            //   b807000000           | test                al, al
            //   8bc8                 | inc                 eax
            //   894344               | setne               bh
            //   488bcb               | inc                 esp
            //   8bd0                 | mov                 byte ptr [ebp + 0x88], bl
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_4 = { e9???????? 488d8ab8010000 e9???????? 488d8ad0000000 e9???????? 488d8a90000000 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d8ab8010000       | mov                 ebx, ecx
            //   e9????????           |                     
            //   488d8ad0000000       | dec                 esp
            //   e9????????           |                     
            //   488d8a90000000       | lea                 edx, [0xfff7625a]
            //   e9????????           |                     

        $sequence_5 = { c645d01c c745d401000000 488975e0 48894598 488d4d90 488b4580 4533e4 }
            // n = 7, score = 100
            //   c645d01c             | mov                 ecx, dword ptr [esp + 0x40]
            //   c745d401000000       | mov                 edx, 0x72
            //   488975e0             | inc                 esp
            //   48894598             | mov                 eax, dword ptr [esp + 0x3c]
            //   488d4d90             | dec                 eax
            //   488b4580             | mov                 ecx, ebx
            //   4533e4               | inc                 esp

        $sequence_6 = { e8???????? 488bcf e8???????? 48c70300000000 4d85ed 7409 498bcd }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bcf               | mov                 eax, edi
            //   e8????????           |                     
            //   48c70300000000       | dec                 ebp
            //   4d85ed               | arpl                sp, cx
            //   7409                 | inc                 esp
            //   498bcd               | mov                 edi, edi

        $sequence_7 = { 48f7e2 488bf2 48c1ee04 48ffc6 0fbe43f1 84c0 740d }
            // n = 7, score = 100
            //   48f7e2               | mov                 ebx, ebp
            //   488bf2               | jmp                 0x1458
            //   48c1ee04             | movzx               edx, word ptr [ecx + 8]
            //   48ffc6               | mov                 ebp, 0x202
            //   0fbe43f1             | dec                 eax
            //   84c0                 | mov                 edx, dword ptr [ebx + 0xb8]
            //   740d                 | dec                 ecx

        $sequence_8 = { e8???????? 8bf8 896c2450 3b44243c 7413 488d15da212800 488bce }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf8                 | test                ecx, ecx
            //   896c2450             | inc                 ebp
            //   3b44243c             | xor                 esp, esp
            //   7413                 | dec                 eax
            //   488d15da212800       | mov                 ebx, ecx
            //   488bce               | inc                 ebp

        $sequence_9 = { ff15???????? 488b4b18 33c0 48898318020000 48898320020000 898328020000 898378020000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488b4b18             | dec                 eax
            //   33c0                 | inc                 ebp
            //   48898318020000       | dec                 eax
            //   48898320020000       | add                 eax, 0x20
            //   898328020000         | dec                 eax
            //   898378020000         | add                 eax, 0x18

    condition:
        7 of them and filesize < 6429696
}