rule win_stealer_0x3401_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stealer_0x3401."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stealer_0x3401"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83e03f 6bc830 8b0495c8710210 8b440818 83f8ff 7409 }
            // n = 6, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b0495c8710210       | mov                 eax, dword ptr [edx*4 + 0x100271c8]
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]
            //   83f8ff               | cmp                 eax, -1
            //   7409                 | je                  0xb

        $sequence_1 = { c685d07dffff00 83f808 720d 40 50 ffb5487effff }
            // n = 6, score = 100
            //   c685d07dffff00       | mov                 byte ptr [ebp - 0x8230], 0
            //   83f808               | cmp                 eax, 8
            //   720d                 | jb                  0xf
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   ffb5487effff         | push                dword ptr [ebp - 0x81b8]

        $sequence_2 = { 68???????? 8bd0 c645fc21 8d4d90 e8???????? }
            // n = 5, score = 100
            //   68????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   c645fc21             | mov                 byte ptr [ebp - 4], 0x21
            //   8d4d90               | lea                 ecx, [ebp - 0x70]
            //   e8????????           |                     

        $sequence_3 = { 8d45bc 837dd010 c745cc01000000 0f4345bc c6400100 8d8578ffffff 50 }
            // n = 7, score = 100
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   837dd010             | cmp                 dword ptr [ebp - 0x30], 0x10
            //   c745cc01000000       | mov                 dword ptr [ebp - 0x34], 1
            //   0f4345bc             | cmovae              eax, dword ptr [ebp - 0x44]
            //   c6400100             | mov                 byte ptr [eax + 1], 0
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   50                   | push                eax

        $sequence_4 = { 660fd645bc f30f7e05???????? 8945b4 a1???????? c78500ffffff3f3f3f00 c78523ffffff00000000 }
            // n = 6, score = 100
            //   660fd645bc           | movq                qword ptr [ebp - 0x44], xmm0
            //   f30f7e05????????     |                     
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax
            //   a1????????           |                     
            //   c78500ffffff3f3f3f00     | mov    dword ptr [ebp - 0x100], 0x3f3f3f
            //   c78523ffffff00000000     | mov    dword ptr [ebp - 0xdd], 0

        $sequence_5 = { 50 b9???????? c645fc19 e8???????? 8d4d90 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   b9????????           |                     
            //   c645fc19             | mov                 byte ptr [ebp - 4], 0x19
            //   e8????????           |                     
            //   8d4d90               | lea                 ecx, [ebp - 0x70]

        $sequence_6 = { 735f 8bc6 8bfe 83e03f c1ff06 6bd830 8b04bdc8710210 }
            // n = 7, score = 100
            //   735f                 | jae                 0x61
            //   8bc6                 | mov                 eax, esi
            //   8bfe                 | mov                 edi, esi
            //   83e03f               | and                 eax, 0x3f
            //   c1ff06               | sar                 edi, 6
            //   6bd830               | imul                ebx, eax, 0x30
            //   8b04bdc8710210       | mov                 eax, dword ptr [edi*4 + 0x100271c8]

        $sequence_7 = { 7534 40 83f8fe 0f8798020000 3bc8 7310 ff7710 }
            // n = 7, score = 100
            //   7534                 | jne                 0x36
            //   40                   | inc                 eax
            //   83f8fe               | cmp                 eax, -2
            //   0f8798020000         | ja                  0x29e
            //   3bc8                 | cmp                 ecx, eax
            //   7310                 | jae                 0x12
            //   ff7710               | push                dword ptr [edi + 0x10]

        $sequence_8 = { 49 83c9fe 41 99 898cb558f0ffff 2bc2 }
            // n = 6, score = 100
            //   49                   | dec                 ecx
            //   83c9fe               | or                  ecx, 0xfffffffe
            //   41                   | inc                 ecx
            //   99                   | cdq                 
            //   898cb558f0ffff       | mov                 dword ptr [ebp + esi*4 - 0xfa8], ecx
            //   2bc2                 | sub                 eax, edx

        $sequence_9 = { 0f95c0 8985a8feffff 3bf7 741f 6690 68???????? 8bcb }
            // n = 7, score = 100
            //   0f95c0               | setne               al
            //   8985a8feffff         | mov                 dword ptr [ebp - 0x158], eax
            //   3bf7                 | cmp                 esi, edi
            //   741f                 | je                  0x21
            //   6690                 | nop                 
            //   68????????           |                     
            //   8bcb                 | mov                 ecx, ebx

    condition:
        7 of them and filesize < 357376
}