rule win_stealhook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stealhook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stealhook"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 410fb6868e000000 41884705 410fb6868f000000 41884704 410fb68690000000 4188470b 418b8690000000 }
            // n = 7, score = 100
            //   410fb6868e000000     | mov                 eax, dword ptr [ebp + 0x1a0]
            //   41884705             | and                 eax, 1
            //   410fb6868f000000     | test                eax, eax
            //   41884704             | je                  0x180
            //   410fb68690000000     | inc                 eax
            //   4188470b             | push                ebp
            //   418b8690000000       | dec                 eax

        $sequence_1 = { e8???????? 48833b00 488d0dd7170500 480f450b }
            // n = 4, score = 100
            //   e8????????           |                     
            //   48833b00             | dec                 eax
            //   488d0dd7170500       | mov                 dword ptr [eax], ecx
            //   480f450b             | je                  0x239

        $sequence_2 = { 4a0fbe8419389a0600 428a8c19489a0600 4c2bd0 418b4048 418b52fc d3ea 03c2 }
            // n = 7, score = 100
            //   4a0fbe8419389a0600     | dec    ecx
            //   428a8c19489a0600     | mov                 edx, ebp
            //   4c2bd0               | dec                 eax
            //   418b4048             | mov                 ecx, ebx
            //   418b52fc             | nop                 
            //   d3ea                 | dec                 eax
            //   03c2                 | lea                 eax, [0x44cd4]

        $sequence_3 = { 83e10f 480fbe8411389a0600 8a8c11489a0600 4c2bc0 418b40fc d3e8 4d894708 }
            // n = 7, score = 100
            //   83e10f               | dec                 eax
            //   480fbe8411389a0600     | lea    eax, [0x4abb7]
            //   8a8c11489a0600       | dec                 eax
            //   4c2bc0               | mov                 dword ptr [ebx], eax
            //   418b40fc             | jmp                 0x26e
            //   d3e8                 | xor                 ebx, ebx
            //   4d894708             | dec                 eax

        $sequence_4 = { 4d8bf8 4c896910 4c8bc6 4c896918 488bee e8???????? 458be5 }
            // n = 7, score = 100
            //   4d8bf8               | cmp                 eax, 2
            //   4c896910             | ja                  0x1d5
            //   4c8bc6               | cmp                 ecx, 1
            //   4c896918             | ja                  0x1d5
            //   488bee               | dec                 esp
            //   e8????????           |                     
            //   458be5               | lea                 edx, [0x22d63]

        $sequence_5 = { 33d2 4903c1 49f7f1 49837e1807 488d0451 498bce 7603 }
            // n = 7, score = 100
            //   33d2                 | inc                 ebp
            //   4903c1               | mov                 ecx, dword ptr [edi - 0x20]
            //   49f7f1               | add                 ebx, edx
            //   49837e1807           | inc                 ecx
            //   488d0451             | add                 ebx, dword ptr [edi - 8]
            //   498bce               | inc                 ecx
            //   7603                 | mov                 eax, edx

        $sequence_6 = { 488b4590 48634804 4c896c0d90 488b4590 }
            // n = 4, score = 100
            //   488b4590             | mov                 dword ptr [ebp + 0x50], eax
            //   48634804             | dec                 eax
            //   4c896c0d90           | mov                 esi, edx
            //   488b4590             | dec                 esp

        $sequence_7 = { e8???????? 90 488d542450 48837c24680f 480f47542450 41b8e8030000 488d4c2470 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488d542450           | add                 edx, ebx
            //   48837c24680f         | dec                 eax
            //   480f47542450         | lea                 ecx, [esp + 0x38]
            //   41b8e8030000         | inc                 ecx
            //   488d4c2470           | mov                 eax, dword ptr [esi + 4]

        $sequence_8 = { 66480f6ec8 660f2f25???????? 0f82df000000 48c1e82c 660feb15???????? 660feb0d???????? 4c8d0dd4fd0000 }
            // n = 7, score = 100
            //   66480f6ec8           | mov                 dword ptr [esi + 0x18], edi
            //   660f2f25????????     |                     
            //   0f82df000000         | dec                 eax
            //   48c1e82c             | lea                 eax, [esp + 0x70]
            //   660feb15????????     |                     
            //   660feb0d????????     |                     
            //   4c8d0dd4fd0000       | dec                 ecx

        $sequence_9 = { 4c8b5577 488d05d9350300 0f1000 4c8bd9 488d4c2430 }
            // n = 5, score = 100
            //   4c8b5577             | dec                 eax
            //   488d05d9350300       | lea                 ecx, [0x55b8e]
            //   0f1000               | dec                 eax
            //   4c8bd9               | mov                 dword ptr [ebx + 0x20], eax
            //   488d4c2430           | dec                 esp

    condition:
        7 of them and filesize < 1129472
}