rule win_stegoloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stegoloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stegoloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 759d 8b043e 0345fc eb03 }
            // n = 4, score = 200
            //   759d                 | jne                 0xffffff9f
            //   8b043e               | mov                 eax, dword ptr [esi + edi]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   eb03                 | jmp                 5

        $sequence_1 = { 51 51 8b4514 8b4d18 53 56 57 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_2 = { 8d4b01 40 57 894c2414 89442410 8d4c2410 }
            // n = 6, score = 200
            //   8d4b01               | lea                 ecx, [ebx + 1]
            //   40                   | inc                 eax
            //   57                   | push                edi
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   8d4c2410             | lea                 ecx, [esp + 0x10]

        $sequence_3 = { 881e 8811 0fb68801010000 0fb69000010000 8a0c01 020c02 8b55fc }
            // n = 7, score = 200
            //   881e                 | mov                 byte ptr [esi], bl
            //   8811                 | mov                 byte ptr [ecx], dl
            //   0fb68801010000       | movzx               ecx, byte ptr [eax + 0x101]
            //   0fb69000010000       | movzx               edx, byte ptr [eax + 0x100]
            //   8a0c01               | mov                 cl, byte ptr [ecx + eax]
            //   020c02               | add                 cl, byte ptr [edx + eax]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_4 = { 897dfc 8bf7 3bf7 743a 8bce }
            // n = 5, score = 200
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   8bf7                 | mov                 esi, edi
            //   3bf7                 | cmp                 esi, edi
            //   743a                 | je                  0x3c
            //   8bce                 | mov                 ecx, esi

        $sequence_5 = { 50 8d45f0 50 53 53 ff75f8 e8???????? }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     

        $sequence_6 = { 8945f0 894dfc 394dfc 753c 394e18 }
            // n = 5, score = 200
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   394dfc               | cmp                 dword ptr [ebp - 4], ecx
            //   753c                 | jne                 0x3e
            //   394e18               | cmp                 dword ptr [esi + 0x18], ecx

        $sequence_7 = { 8bd3 e8???????? 03f3 59 8945f4 85c0 }
            // n = 6, score = 200
            //   8bd3                 | mov                 edx, ebx
            //   e8????????           |                     
            //   03f3                 | add                 esi, ebx
            //   59                   | pop                 ecx
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   85c0                 | test                eax, eax

        $sequence_8 = { 2b4c2408 8b542414 8a09 ff442414 48 880a }
            // n = 6, score = 200
            //   2b4c2408             | sub                 ecx, dword ptr [esp + 8]
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   8a09                 | mov                 cl, byte ptr [ecx]
            //   ff442414             | inc                 dword ptr [esp + 0x14]
            //   48                   | dec                 eax
            //   880a                 | mov                 byte ptr [edx], cl

        $sequence_9 = { 895e04 895e08 895e0c 7611 53 }
            // n = 5, score = 200
            //   895e04               | mov                 dword ptr [esi + 4], ebx
            //   895e08               | mov                 dword ptr [esi + 8], ebx
            //   895e0c               | mov                 dword ptr [esi + 0xc], ebx
            //   7611                 | jbe                 0x13
            //   53                   | push                ebx

        $sequence_10 = { ff7108 e8???????? c3 56 8bf1 e8???????? f644240801 }
            // n = 7, score = 200
            //   ff7108               | push                dword ptr [ecx + 8]
            //   e8????????           |                     
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   f644240801           | test                byte ptr [esp + 8], 1

        $sequence_11 = { 49 49 51 ff7004 8b4f04 }
            // n = 5, score = 200
            //   49                   | dec                 ecx
            //   49                   | dec                 ecx
            //   51                   | push                ecx
            //   ff7004               | push                dword ptr [eax + 4]
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]

        $sequence_12 = { ff442414 48 880a 75e9 eb5b 83e803 eb02 }
            // n = 7, score = 200
            //   ff442414             | inc                 dword ptr [esp + 0x14]
            //   48                   | dec                 eax
            //   880a                 | mov                 byte ptr [edx], cl
            //   75e9                 | jne                 0xffffffeb
            //   eb5b                 | jmp                 0x5d
            //   83e803               | sub                 eax, 3
            //   eb02                 | jmp                 4

        $sequence_13 = { 8bf8 33f6 8b1c3e 6a40 83c604 8b043e }
            // n = 6, score = 200
            //   8bf8                 | mov                 edi, eax
            //   33f6                 | xor                 esi, esi
            //   8b1c3e               | mov                 ebx, dword ptr [esi + edi]
            //   6a40                 | push                0x40
            //   83c604               | add                 esi, 4
            //   8b043e               | mov                 eax, dword ptr [esi + edi]

        $sequence_14 = { 83ceff 394c240c 7629 57 8b44240c 0fb61401 6a08 }
            // n = 7, score = 200
            //   83ceff               | or                  esi, 0xffffffff
            //   394c240c             | cmp                 dword ptr [esp + 0xc], ecx
            //   7629                 | jbe                 0x2b
            //   57                   | push                edi
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   0fb61401             | movzx               edx, byte ptr [ecx + eax]
            //   6a08                 | push                8

        $sequence_15 = { c645ff00 8bc8 8bc7 f7f1 }
            // n = 4, score = 200
            //   c645ff00             | mov                 byte ptr [ebp - 1], 0
            //   8bc8                 | mov                 ecx, eax
            //   8bc7                 | mov                 eax, edi
            //   f7f1                 | div                 ecx

    condition:
        7 of them and filesize < 802816
}