rule win_stop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stop"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff15???????? 8bf8 85ff 790f }
            // n = 5, score = 600
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   790f                 | jns                 0x11

        $sequence_1 = { ff15???????? 8bf8 85ff 790f }
            // n = 4, score = 600
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   790f                 | jns                 0x11

        $sequence_2 = { 51 dd1c24 e8???????? dc4de0 }
            // n = 4, score = 600
            //   51                   | push                ecx
            //   dd1c24               | fstp                qword ptr [esp]
            //   e8????????           |                     
            //   dc4de0               | fmul                qword ptr [ebp - 0x20]

        $sequence_3 = { 56 6a00 ff7508 68???????? 6a00 }
            // n = 5, score = 600
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_4 = { 33c9 eb14 8bce 8d5902 668b01 83c102 6685c0 }
            // n = 7, score = 600
            //   33c9                 | xor                 ecx, ecx
            //   eb14                 | jmp                 0x16
            //   8bce                 | mov                 ecx, esi
            //   8d5902               | lea                 ebx, [ecx + 2]
            //   668b01               | mov                 ax, word ptr [ecx]
            //   83c102               | add                 ecx, 2
            //   6685c0               | test                ax, ax

        $sequence_5 = { 33c9 eb14 8bce 8d5902 }
            // n = 4, score = 600
            //   33c9                 | xor                 ecx, ecx
            //   eb14                 | jmp                 0x16
            //   8bce                 | mov                 ecx, esi
            //   8d5902               | lea                 ebx, [ecx + 2]

        $sequence_6 = { ffd6 85c0 75e2 5f }
            // n = 4, score = 600
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   75e2                 | jne                 0xffffffe4
            //   5f                   | pop                 edi

        $sequence_7 = { 68f4010000 57 ff15???????? 57 }
            // n = 4, score = 600
            //   68f4010000           | push                0x1f4
            //   57                   | push                edi
            //   ff15????????         |                     
            //   57                   | push                edi

        $sequence_8 = { 50 ffd6 85c0 75e8 6a0a ff7304 }
            // n = 6, score = 600
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   75e8                 | jne                 0xffffffea
            //   6a0a                 | push                0xa
            //   ff7304               | push                dword ptr [ebx + 4]

        $sequence_9 = { ff7508 ffd0 5d c3 8b0d???????? 33d2 }
            // n = 6, score = 600
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b0d????????         |                     
            //   33d2                 | xor                 edx, edx

    condition:
        7 of them and filesize < 6029312
}