rule win_stowaway_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stowaway."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stowaway"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 76e8 77e8 78e8 79e8 }
            // n = 4, score = 200
            //   76e8                 | jbe                 0xffffffea
            //   77e8                 | ja                  0xffffffea
            //   78e8                 | js                  0xffffffea
            //   79e8                 | jns                 0xffffffea

        $sequence_1 = { 78e8 79e8 7ae8 ce f67be8 }
            // n = 5, score = 200
            //   78e8                 | js                  0xffffffea
            //   79e8                 | jns                 0xffffffea
            //   7ae8                 | jp                  0xffffffea
            //   ce                   | into                
            //   f67be8               | idiv                byte ptr [ebx - 0x18]

        $sequence_2 = { ce f67be8 7ce8 7de8 }
            // n = 4, score = 200
            //   ce                   | into                
            //   f67be8               | idiv                byte ptr [ebx - 0x18]
            //   7ce8                 | jl                  0xffffffea
            //   7de8                 | jge                 0xffffffea

        $sequence_3 = { a3???????? 4e fb b501 }
            // n = 4, score = 200
            //   a3????????           |                     
            //   4e                   | dec                 esi
            //   fb                   | sti                 
            //   b501                 | mov                 ch, 1

        $sequence_4 = { 751e 53 2661 6d b040 3d1db5094f }
            // n = 6, score = 100
            //   751e                 | jne                 0x20
            //   53                   | push                ebx
            //   2661                 | popal               
            //   6d                   | insd                dword ptr es:[edi], dx
            //   b040                 | mov                 al, 0x40
            //   3d1db5094f           | cmp                 eax, 0x4f09b51d

        $sequence_5 = { 2a37 e394 5e b5a9 0e 2cc6 ec }
            // n = 7, score = 100
            //   2a37                 | sub                 dh, byte ptr [edi]
            //   e394                 | jecxz               0xffffff96
            //   5e                   | pop                 esi
            //   b5a9                 | mov                 ch, 0xa9
            //   0e                   | push                cs
            //   2cc6                 | sub                 al, 0xc6
            //   ec                   | in                  al, dx

        $sequence_6 = { 5b 6b5e045f aa 43 9a7f6eb1f75c72 7f30 fa }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   6b5e045f             | imul                ebx, dword ptr [esi + 4], 0x5f
            //   aa                   | stosb               byte ptr es:[edi], al
            //   43                   | inc                 ebx
            //   9a7f6eb1f75c72       | lcall               0x725c:0xf7b16e7f
            //   7f30                 | jg                  0x32
            //   fa                   | cli                 

        $sequence_7 = { 50 91 3e06 48 52 2692 4e }
            // n = 7, score = 100
            //   50                   | push                eax
            //   91                   | xchg                eax, ecx
            //   3e06                 | push                es
            //   48                   | dec                 eax
            //   52                   | push                edx
            //   2692                 | xchg                eax, edx
            //   4e                   | dec                 esi

        $sequence_8 = { 1b7f1c b567 8110932238ba 81f82f2437b0 645b f257 326640 }
            // n = 7, score = 100
            //   1b7f1c               | sbb                 edi, dword ptr [edi + 0x1c]
            //   b567                 | mov                 ch, 0x67
            //   8110932238ba         | adc                 dword ptr [eax], 0xba382293
            //   81f82f2437b0         | cmp                 eax, 0xb037242f
            //   645b                 | pop                 ebx
            //   f257                 | push                edi
            //   326640               | xor                 ah, byte ptr [esi + 0x40]

        $sequence_9 = { d4ff 57 ed 7a80 51 80534080 }
            // n = 6, score = 100
            //   d4ff                 | aam                 0xff
            //   57                   | push                edi
            //   ed                   | in                  eax, dx
            //   7a80                 | jp                  0xffffff82
            //   51                   | push                ecx
            //   80534080             | adc                 byte ptr [ebx + 0x40], 0x80

        $sequence_10 = { 99 0039 801002 3900 99 }
            // n = 5, score = 100
            //   99                   | cdq                 
            //   0039                 | add                 byte ptr [ecx], bh
            //   801002               | adc                 byte ptr [eax], 2
            //   3900                 | cmp                 dword ptr [eax], eax
            //   99                   | cdq                 

        $sequence_11 = { e774 5b 004f49 5c }
            // n = 4, score = 100
            //   e774                 | out                 0x74, eax
            //   5b                   | pop                 ebx
            //   004f49               | add                 byte ptr [edi + 0x49], cl
            //   5c                   | pop                 esp

        $sequence_12 = { 8d843000a03b00 01f3 50 83c708 }
            // n = 4, score = 100
            //   8d843000a03b00       | lea                 eax, [eax + esi + 0x3ba000]
            //   01f3                 | add                 ebx, esi
            //   50                   | push                eax
            //   83c708               | add                 edi, 8

        $sequence_13 = { 777c 7781 7782 7783 7786 7787 }
            // n = 6, score = 100
            //   777c                 | ja                  0x7e
            //   7781                 | ja                  0xffffff83
            //   7782                 | ja                  0xffffff84
            //   7783                 | ja                  0xffffff85
            //   7786                 | ja                  0xffffff88
            //   7787                 | ja                  0xffffff89

        $sequence_14 = { 3c77 0c35 f20b18 40 }
            // n = 4, score = 100
            //   3c77                 | cmp                 al, 0x77
            //   0c35                 | or                  al, 0x35
            //   f20b18               | or                  ebx, dword ptr [eax]
            //   40                   | inc                 eax

        $sequence_15 = { f3676d 51 99 9f 4b 8099543c7bbf7a }
            // n = 6, score = 100
            //   f3676d               | rep insd            dword ptr es:[di], dx
            //   51                   | push                ecx
            //   99                   | cdq                 
            //   9f                   | lahf                
            //   4b                   | dec                 ebx
            //   8099543c7bbf7a       | sbb                 byte ptr [ecx - 0x4084c3ac], 0x7a

        $sequence_16 = { a5 ed 91 34cf }
            // n = 4, score = 100
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   ed                   | in                  eax, dx
            //   91                   | xchg                eax, ecx
            //   34cf                 | xor                 al, 0xcf

        $sequence_17 = { 60 41 69e038173794 6c 5c d10f }
            // n = 6, score = 100
            //   60                   | pushal              
            //   41                   | inc                 ecx
            //   69e038173794         | imul                esp, eax, 0x94371738
            //   6c                   | insb                byte ptr es:[edi], dx
            //   5c                   | pop                 esp
            //   d10f                 | ror                 dword ptr [edi], 1

        $sequence_18 = { d7 80cf73 c9 f0f3f9 }
            // n = 4, score = 100
            //   d7                   | xlatb               
            //   80cf73               | or                  bh, 0x73
            //   c9                   | leave               
            //   f0f3f9               | stc                 

        $sequence_19 = { a4 49 07 04bc 3c2f }
            // n = 5, score = 100
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   49                   | dec                 ecx
            //   07                   | pop                 es
            //   04bc                 | add                 al, 0xbc
            //   3c2f                 | cmp                 al, 0x2f

    condition:
        7 of them and filesize < 8003584
}