rule win_stration_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stration."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stration"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7407 6a01 e8???????? 8a15???????? }
            // n = 4, score = 100
            //   7407                 | je                  9
            //   6a01                 | push                1
            //   e8????????           |                     
            //   8a15????????         |                     

        $sequence_1 = { 8b4c2434 c1e908 32c8 884c2435 8b542434 c1ea10 }
            // n = 6, score = 100
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   c1e908               | shr                 ecx, 8
            //   32c8                 | xor                 cl, al
            //   884c2435             | mov                 byte ptr [esp + 0x35], cl
            //   8b542434             | mov                 edx, dword ptr [esp + 0x34]
            //   c1ea10               | shr                 edx, 0x10

        $sequence_2 = { 56 89442420 b37b e8???????? 85ff }
            // n = 5, score = 100
            //   56                   | push                esi
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   b37b                 | mov                 bl, 0x7b
            //   e8????????           |                     
            //   85ff                 | test                edi, edi

        $sequence_3 = { 8d4c240c b81f85eb51 f7e9 8bc1 c1fa05 50 }
            // n = 6, score = 100
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   b81f85eb51           | mov                 eax, 0x51eb851f
            //   f7e9                 | imul                ecx
            //   8bc1                 | mov                 eax, ecx
            //   c1fa05               | sar                 edx, 5
            //   50                   | push                eax

        $sequence_4 = { 85db 7474 57 e8???????? 83c404 85c0 }
            // n = 6, score = 100
            //   85db                 | test                ebx, ebx
            //   7474                 | je                  0x76
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_5 = { 56 8be8 e8???????? 6a64 }
            // n = 4, score = 100
            //   56                   | push                esi
            //   8be8                 | mov                 ebp, eax
            //   e8????????           |                     
            //   6a64                 | push                0x64

        $sequence_6 = { 50 ba11010000 8bcf e8???????? 83fe66 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ba11010000           | mov                 edx, 0x111
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   83fe66               | cmp                 esi, 0x66

        $sequence_7 = { 83ec14 85c0 756f a1???????? 8b0d???????? }
            // n = 5, score = 100
            //   83ec14               | sub                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   756f                 | jne                 0x71
            //   a1????????           |                     
            //   8b0d????????         |                     

        $sequence_8 = { ff15???????? 8a0d???????? 22cb 85f6 8935???????? }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8a0d????????         |                     
            //   22cb                 | and                 cl, bl
            //   85f6                 | test                esi, esi
            //   8935????????         |                     

        $sequence_9 = { 68???????? e8???????? a1???????? 0fafc6 }
            // n = 4, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   a1????????           |                     
            //   0fafc6               | imul                eax, esi

    condition:
        7 of them and filesize < 49152
}