rule win_stresspaint_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stresspaint."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stresspaint"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d542478 51 52 e8???????? 8b44244c }
            // n = 5, score = 100
            //   8d542478             | lea                 edx, [esp + 0x78]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b44244c             | mov                 eax, dword ptr [esp + 0x4c]

        $sequence_1 = { 8d542478 c6042b00 3bda 7505 }
            // n = 4, score = 100
            //   8d542478             | lea                 edx, [esp + 0x78]
            //   c6042b00             | mov                 byte ptr [ebx + ebp], 0
            //   3bda                 | cmp                 ebx, edx
            //   7505                 | jne                 7

        $sequence_2 = { 0103 014510 294514 83665800 }
            // n = 4, score = 100
            //   0103                 | add                 dword ptr [ebx], eax
            //   014510               | add                 dword ptr [ebp + 0x10], eax
            //   294514               | sub                 dword ptr [ebp + 0x14], eax
            //   83665800             | and                 dword ptr [esi + 0x58], 0

        $sequence_3 = { 0106 83560400 837d1c00 7494 }
            // n = 4, score = 100
            //   0106                 | add                 dword ptr [esi], eax
            //   83560400             | adc                 dword ptr [esi + 4], 0
            //   837d1c00             | cmp                 dword ptr [ebp + 0x1c], 0
            //   7494                 | je                  0xffffff96

        $sequence_4 = { 0103 014510 294674 8b4674 }
            // n = 4, score = 100
            //   0103                 | add                 dword ptr [ebx], eax
            //   014510               | add                 dword ptr [ebp + 0x10], eax
            //   294674               | sub                 dword ptr [esi + 0x74], eax
            //   8b4674               | mov                 eax, dword ptr [esi + 0x74]

        $sequence_5 = { 8d542901 52 6a1e 56 }
            // n = 4, score = 100
            //   8d542901             | lea                 edx, [ecx + ebp + 1]
            //   52                   | push                edx
            //   6a1e                 | push                0x1e
            //   56                   | push                esi

        $sequence_6 = { 0107 115f04 3bcb 7508 }
            // n = 4, score = 100
            //   0107                 | add                 dword ptr [edi], eax
            //   115f04               | adc                 dword ptr [edi + 4], ebx
            //   3bcb                 | cmp                 ecx, ebx
            //   7508                 | jne                 0xa

        $sequence_7 = { 8d542478 52 57 e8???????? 83c408 }
            // n = 5, score = 100
            //   8d542478             | lea                 edx, [esp + 0x78]
            //   52                   | push                edx
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_8 = { 8d542478 f3ab 8b8c24a4000000 8b8424a0000000 }
            // n = 4, score = 100
            //   8d542478             | lea                 edx, [esp + 0x78]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b8c24a4000000       | mov                 ecx, dword ptr [esp + 0xa4]
            //   8b8424a0000000       | mov                 eax, dword ptr [esp + 0xa0]

        $sequence_9 = { 0107 83570400 85c9 7508 }
            // n = 4, score = 100
            //   0107                 | add                 dword ptr [edi], eax
            //   83570400             | adc                 dword ptr [edi + 4], 0
            //   85c9                 | test                ecx, ecx
            //   7508                 | jne                 0xa

        $sequence_10 = { 8d542478 898c2498010000 8d8c2494010000 52 }
            // n = 4, score = 100
            //   8d542478             | lea                 edx, [esp + 0x78]
            //   898c2498010000       | mov                 dword ptr [esp + 0x198], ecx
            //   8d8c2494010000       | lea                 ecx, [esp + 0x194]
            //   52                   | push                edx

        $sequence_11 = { 010b 8945fc 8bc2 83530400 }
            // n = 4, score = 100
            //   010b                 | add                 dword ptr [ebx], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8bc2                 | mov                 eax, edx
            //   83530400             | adc                 dword ptr [ebx + 4], 0

        $sequence_12 = { 0103 ebaa 8b442408 56 }
            // n = 4, score = 100
            //   0103                 | add                 dword ptr [ebx], eax
            //   ebaa                 | jmp                 0xffffffac
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   56                   | push                esi

        $sequence_13 = { 8d542474 51 55 52 8bce e8???????? }
            // n = 6, score = 100
            //   8d542474             | lea                 edx, [esp + 0x74]
            //   51                   | push                ecx
            //   55                   | push                ebp
            //   52                   | push                edx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_14 = { 0108 8b8e44010000 114804 8b4f18 }
            // n = 4, score = 100
            //   0108                 | add                 dword ptr [eax], ecx
            //   8b8e44010000         | mov                 ecx, dword ptr [esi + 0x144]
            //   114804               | adc                 dword ptr [eax + 4], ecx
            //   8b4f18               | mov                 ecx, dword ptr [edi + 0x18]

        $sequence_15 = { 8d542901 52 6a1f 56 }
            // n = 4, score = 100
            //   8d542901             | lea                 edx, [ecx + ebp + 1]
            //   52                   | push                edx
            //   6a1f                 | push                0x1f
            //   56                   | push                esi

    condition:
        7 of them and filesize < 1155072
}