rule win_strifewater_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.strifewater_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.strifewater_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b7c2478 4883c450 415e c3 488d151f910400 488d4c2420 e8???????? }
            // n = 7, score = 100
            //   488b7c2478           | dec                 esp
            //   4883c450             | lea                 eax, [ebp + 0x130]
            //   415e                 | dec                 eax
            //   c3                   | lea                 edx, [0xffffd8c9]
            //   488d151f910400       | dec                 eax
            //   488d4c2420           | lea                 ecx, [ebp + 8]
            //   e8????????           |                     

        $sequence_1 = { 48895320 488d3d472d0800 be05000000 498bd5 8bce }
            // n = 5, score = 100
            //   48895320             | movsx               ebx, bx
            //   488d3d472d0800       | dec                 eax
            //   be05000000           | imul                eax, ebx, 0xc8
            //   498bd5               | inc                 esp
            //   8bce                 | lea                 eax, [ecx - 0x20]

        $sequence_2 = { 488b07 48634804 4803cf 85f6 741a 8b5110 0bd6 }
            // n = 7, score = 100
            //   488b07               | mov                 ecx, dword ptr [ebx + 0x80]
            //   48634804             | dec                 eax
            //   4803cf               | mov                 dword ptr [ebp - 0x18], 0xf
            //   85f6                 | dec                 eax
            //   741a                 | mov                 dword ptr [ebp - 0x20], ebx
            //   8b5110               | mov                 byte ptr [ebp - 0x30], bl
            //   0bd6                 | inc                 ebp

        $sequence_3 = { 90 498b06 488b5858 488bcb e8???????? 4c8d4def 4c8d056e710500 }
            // n = 7, score = 100
            //   90                   | test                eax, eax
            //   498b06               | je                  0x11db
            //   488b5858             | cmp                 dword ptr [eax], 0
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   4c8d4def             | lea                 ecx, [0x8a24b]
            //   4c8d056e710500       | int3                

        $sequence_4 = { 48c7442420feffffff 48895c2440 488bf9 488d056ae70800 488901 4883c140 4533c0 }
            // n = 7, score = 100
            //   48c7442420feffffff     | mov    ebx, ecx
            //   48895c2440           | dec                 eax
            //   488bf9               | mov                 dword ptr [ecx], eax
            //   488d056ae70800       | test                dl, 1
            //   488901               | je                  0x1fc5
            //   4883c140             | mov                 edx, 0x30
            //   4533c0               | dec                 eax

        $sequence_5 = { e9???????? 488b9540070000 4c8d0526ae0100 498bce e8???????? 85c0 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   488b9540070000       | lea                 ecx, [ebp + 0x190]
            //   4c8d0526ae0100       | dec                 eax
            //   498bce               | lea                 ecx, [ebp + 0x2330]
            //   e8????????           |                     
            //   85c0                 | inc                 ecx

        $sequence_6 = { 488d0595ec0500 488906 eb02 33f6 4c8b05???????? 4d85c0 753c }
            // n = 7, score = 100
            //   488d0595ec0500       | sar                 ecx, 6
            //   488906               | inc                 ecx
            //   eb02                 | lea                 ecx, [eax + 2]
            //   33f6                 | dec                 esp
            //   4c8b05????????       |                     
            //   4d85c0               | lea                 ecx, [0x558e3]
            //   753c                 | cmp                 ecx, 1

        $sequence_7 = { 48634804 83640c48fb 4533ff eb0d 408ad7 488d4c2430 e8???????? }
            // n = 7, score = 100
            //   48634804             | mov                 dword ptr [ebp - 0x20], eax
            //   83640c48fb           | mov                 dword ptr [ecx + 0x28], edx
            //   4533ff               | mov                 eax, 0x80004005
            //   eb0d                 | dec                 eax
            //   408ad7               | mov                 ecx, dword ptr [ebp + 0x40]
            //   488d4c2430           | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 48898424f0000000 488b4e08 4885c9 7509 488d1598330900 eb0d 488b5128 }
            // n = 7, score = 100
            //   48898424f0000000     | and                 byte ptr [ecx + edi + 0x3d], 0xfd
            //   488b4e08             | cmp                 eax, ebx
            //   4885c9               | dec                 eax
            //   7509                 | lea                 edx, [0x8f67c]
            //   488d1598330900       | dec                 eax
            //   eb0d                 | lea                 ecx, [ebp + 0x260]
            //   488b5128             | test                eax, eax

        $sequence_9 = { 8bc3 874710 85c0 7421 8365d800 488d059ca1feff 488945e0 }
            // n = 7, score = 100
            //   8bc3                 | dec                 eax
            //   874710               | mov                 edx, esi
            //   85c0                 | dec                 eax
            //   7421                 | lea                 eax, [0x41ec1]
            //   8365d800             | ret                 
            //   488d059ca1feff       | dec                 eax
            //   488945e0             | lea                 eax, [0x41ebd]

    condition:
        7 of them and filesize < 1552384
}