rule win_strikesuit_gift_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.strikesuit_gift."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.strikesuit_gift"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 06 2000100000 1f40 2801000006 }
            // n = 4, score = 100
            //   06                   | mov                 word ptr [eax], fs
            //   2000100000           | add                 byte ptr [eax], al
            //   1f40                 | add                 dword ptr [eax], ebp
            //   2801000006           | push                es

        $sequence_1 = { 7245000070 7e1b00000a 6f2500000a 1305 1105 7249000070 }
            // n = 6, score = 100
            //   7245000070           | and                 eax, 0x6f0a0000
            //   7e1b00000a           | add                 byte ptr ss:[eax], al
            //   6f2500000a           | or                  dl, byte ptr [ebx]
            //   1305                 | pop                 es
            //   1105                 | adc                 dword ptr [edi], eax
            //   7249000070           | sub                 eax, 0x172083f

        $sequence_2 = { 2d3f 08 8e 69 05 59 }
            // n = 6, score = 100
            //   2d3f                 |                     
            //   08                   |                     
            //   8e                   | sub                 al, 8
            //   69                   | jle                 4
            //   05                   | add                 byte ptr [eax], al
            //   59                   | add                 al, 0x16

        $sequence_3 = { 2801000006 0b 16 0c 2b0e 07 08 }
            // n = 7, score = 100
            //   2801000006           | or                  eax, 0xff20
            //   0b                   | add                 byte ptr [edi - 0x2e], bl
            //   16                   | pushfd              
            //   0c                   | pop                 es
            //   2b0e                 | pop                 ss
            //   07                   | pop                 eax
            //   08                   | fiadd               word ptr es:[eax]

        $sequence_4 = { 7503000002 0d 09 7e1e00000a 6f0c000006 }
            // n = 5, score = 100
            //   7503000002           | add                 byte ptr [eax], al
            //   0d                   | or                  dl, byte ptr [ebx]
            //   09                   | add                 eax, 0x2e1f0511
            //   7e1e00000a           | pop                 ds
            //   6f0c000006           | das                 

        $sequence_5 = { a2 1105 17 58 1305 1105 08 }
            // n = 7, score = 100
            //   a2                   | sub                 byte ptr [eax + eax], dh
            //   1105                 | add                 byte ptr [edx], cl
            //   17                   | sub                 byte ptr [edi], dh
            //   58                   | add                 byte ptr [eax], al
            //   1305                 | adc                 dword ptr [edi], eax
            //   1105                 | sub                 byte ptr [eax], bh
            //   08                   | add                 byte ptr [eax], al

        $sequence_6 = { 07 d003000002 282000000a 282100000a }
            // n = 4, score = 100
            //   07                   | add                 byte ptr [eax], al
            //   d003000002           | add                 al, 0x8e
            //   282000000a           | pop                 es
            //   282100000a           | xchg                eax, ecx

        $sequence_7 = { 1107 7e01000004 1b 6f1800000a }
            // n = 4, score = 100
            //   1107                 | outsd               dx, dword ptr [esi]
            //   7e01000004           | sbb                 dword ptr [eax], eax
            //   1b                   | add                 byte ptr [edx], cl
            //   6f1800000a           |                     

        $sequence_8 = { 731500000a 0b 16 0c }
            // n = 4, score = 100
            //   731500000a           | add                 byte ptr [eax + 0x28], dh
            //   0b                   | and                 eax, dword ptr [eax]
            //   16                   | add                 byte ptr [edx], cl
            //   0c                   | or                  al, byte ptr [esi]

        $sequence_9 = { 03 282c00000a 0a 16 0b 2b19 02 }
            // n = 7, score = 100
            //   03                   | push                ss
            //   282c00000a           | or                  eax, 0xa838
            //   0a                   | add                 dh, bl
            //   16                   | add                 byte ptr [esi], al
            //   0b                   | sub                 al, 7
            //   2b19                 | add                 al, byte ptr [esi]
            //   02                   | sub                 byte ptr [edi], al

    condition:
        7 of them and filesize < 50176
}