rule win_strongpity_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.strongpity."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.strongpity"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 74b8 6a14 59 }
            // n = 5, score = 700
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   74b8                 | je                  0xffffffba
            //   6a14                 | push                0x14
            //   59                   | pop                 ecx

        $sequence_1 = { 6a1f 56 ff15???????? 33c0 50 ff7710 }
            // n = 6, score = 700
            //   6a1f                 | push                0x1f
            //   56                   | push                esi
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   ff7710               | push                dword ptr [edi + 0x10]

        $sequence_2 = { 8b45ec 6a02 5a 663938 750d 49 03c2 }
            // n = 7, score = 700
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   6a02                 | push                2
            //   5a                   | pop                 edx
            //   663938               | cmp                 word ptr [eax], di
            //   750d                 | jne                 0xf
            //   49                   | dec                 ecx
            //   03c2                 | add                 eax, edx

        $sequence_3 = { 740d 817df4c8000000 7504 8bc6 }
            // n = 4, score = 700
            //   740d                 | je                  0xf
            //   817df4c8000000       | cmp                 dword ptr [ebp - 0xc], 0xc8
            //   7504                 | jne                 6
            //   8bc6                 | mov                 eax, esi

        $sequence_4 = { 85ff 7507 33c0 e9???????? b90a020000 33d2 8810 }
            // n = 7, score = 700
            //   85ff                 | test                edi, edi
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   b90a020000           | mov                 ecx, 0x20a
            //   33d2                 | xor                 edx, edx
            //   8810                 | mov                 byte ptr [eax], dl

        $sequence_5 = { 83e901 75f8 8bcb 897dd0 c745d404010000 }
            // n = 5, score = 700
            //   83e901               | sub                 ecx, 1
            //   75f8                 | jne                 0xfffffffa
            //   8bcb                 | mov                 ecx, ebx
            //   897dd0               | mov                 dword ptr [ebp - 0x30], edi
            //   c745d404010000       | mov                 dword ptr [ebp - 0x2c], 0x104

        $sequence_6 = { 7433 53 56 ff15???????? 85c0 7427 53 }
            // n = 7, score = 700
            //   7433                 | je                  0x35
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7427                 | je                  0x29
            //   53                   | push                ebx

        $sequence_7 = { 8819 41 83e801 75f8 ff75d0 68???????? }
            // n = 6, score = 700
            //   8819                 | mov                 byte ptr [ecx], bl
            //   41                   | inc                 ecx
            //   83e801               | sub                 eax, 1
            //   75f8                 | jne                 0xfffffffa
            //   ff75d0               | push                dword ptr [ebp - 0x30]
            //   68????????           |                     

        $sequence_8 = { 5e 5d 8d432f 5b 8b4c2418 }
            // n = 5, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   8d432f               | lea                 eax, [ebx + 0x2f]
            //   5b                   | pop                 ebx
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]

        $sequence_9 = { 5e 5d 8bc3 5b 83c410 c3 8b464c }
            // n = 7, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   8bc3                 | mov                 eax, ebx
            //   5b                   | pop                 ebx
            //   83c410               | add                 esp, 0x10
            //   c3                   | ret                 
            //   8b464c               | mov                 eax, dword ptr [esi + 0x4c]

        $sequence_10 = { 5e 5d b803000000 5b 59 c3 8b06 }
            // n = 7, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   b803000000           | mov                 eax, 3
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_11 = { 5e 5d 8d431b 5b 8b8c24a8090000 }
            // n = 5, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   8d431b               | lea                 eax, [ebx + 0x1b]
            //   5b                   | pop                 ebx
            //   8b8c24a8090000       | mov                 ecx, dword ptr [esp + 0x9a8]

        $sequence_12 = { 5e 5d 8919 33c0 5b 59 }
            // n = 6, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   8919                 | mov                 dword ptr [ecx], ebx
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx

        $sequence_13 = { 5e 5d 8bc3 c7826c02000001000000 5b 83c410 }
            // n = 6, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   8bc3                 | mov                 eax, ebx
            //   c7826c02000001000000     | mov    dword ptr [edx + 0x26c], 1
            //   5b                   | pop                 ebx
            //   83c410               | add                 esp, 0x10

        $sequence_14 = { 5e 5d b809000000 5b 83c408 c3 8b4640 }
            // n = 7, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   b809000000           | mov                 eax, 9
            //   5b                   | pop                 ebx
            //   83c408               | add                 esp, 8
            //   c3                   | ret                 
            //   8b4640               | mov                 eax, dword ptr [esi + 0x40]

        $sequence_15 = { 7410 5f c7866c02000001000000 5e 83c410 c3 }
            // n = 6, score = 300
            //   7410                 | je                  0x12
            //   5f                   | pop                 edi
            //   c7866c02000001000000     | mov    dword ptr [esi + 0x26c], 1
            //   5e                   | pop                 esi
            //   83c410               | add                 esp, 0x10
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 999424
}