rule win_subzero_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.subzero."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.subzero"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c2bc8 488d040f 4885c0 741f 410fb70411 6685c0 7415 }
            // n = 7, score = 100
            //   4c2bc8               | mov                 eax, dword ptr [ebp - 0x60]
            //   488d040f             | dec                 eax
            //   4885c0               | mov                 eax, dword ptr [ebp - 0x60]
            //   741f                 | dec                 eax
            //   410fb70411           | mov                 dword ptr [ebp - 0x20], eax
            //   6685c0               | mov                 dword ptr [ebp - 0x60], 5
            //   7415                 | test                edx, edx

        $sequence_1 = { 90 e9???????? 488b4c2428 448bc8 4c8bc7 bac3120000 e8???????? }
            // n = 7, score = 100
            //   90                   | cmp                 edx, 2
            //   e9????????           |                     
            //   488b4c2428           | jl                  0x403
            //   448bc8               | dec                 eax
            //   4c8bc7               | cmp                 edx, 0x18
            //   bac3120000           | jg                  0x403
            //   e8????????           |                     

        $sequence_2 = { e9???????? 32d2 e9???????? b001 e9???????? b941010000 84d2 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   32d2                 | sub                 esp, 0x90
            //   e9????????           |                     
            //   b001                 | dec                 ecx
            //   e9????????           |                     
            //   b941010000           | mov                 dword ptr [ebx - 0x48], 0xfffffffe
            //   84d2                 | dec                 ecx

        $sequence_3 = { eb58 48ff15???????? 0f1f440000 4c8d4704 33d2 488bc8 48ff15???????? }
            // n = 7, score = 100
            //   eb58                 | mov                 ebx, 0x8007000e
            //   48ff15????????       |                     
            //   0f1f440000           | dec                 eax
            //   4c8d4704             | lea                 ecx, [esp + 0x20]
            //   33d2                 | nop                 dword ptr [eax + eax]
            //   488bc8               | dec                 eax
            //   48ff15????????       |                     

        $sequence_4 = { bb02400080 81fb02400080 754e 488d15ba700600 498bca e8???????? }
            // n = 6, score = 100
            //   bb02400080           | inc                 ecx
            //   81fb02400080         | mov                 ebx, eax
            //   754e                 | dec                 eax
            //   488d15ba700600       | mov                 edi, edx
            //   498bca               | push                edi
            //   e8????????           |                     

        $sequence_5 = { ba224e0000 488bcb 48ff15???????? 0f1f440000 488d4de7 48ff15???????? 0f1f440000 }
            // n = 7, score = 100
            //   ba224e0000           | test                esi, esi
            //   488bcb               | je                  0x1335
            //   48ff15????????       |                     
            //   0f1f440000           | dec                 esp
            //   488d4de7             | mov                 dword ptr [esp + 0x20], esi
            //   48ff15????????       |                     
            //   0f1f440000           | inc                 ecx

        $sequence_6 = { f7d3 81e305400080 488d4c2420 e8???????? 488b742458 8bc3 488b5c2450 }
            // n = 7, score = 100
            //   f7d3                 | je                  0x1067
            //   81e305400080         | dec                 eax
            //   488d4c2420           | mov                 eax, dword ptr [esp + 0x40]
            //   e8????????           |                     
            //   488b742458           | inc                 ebp
            //   8bc3                 | xor                 esi, esi
            //   488b5c2450           | dec                 eax

        $sequence_7 = { 418bdf 483dfeffff7f 0f8739ee0100 85db 0f883bee0100 4c8bcd 4c89642420 }
            // n = 7, score = 100
            //   418bdf               | nop                 
            //   483dfeffff7f         | dec                 eax
            //   0f8739ee0100         | lea                 ecx, [esp + 0x48]
            //   85db                 | nop                 
            //   0f883bee0100         | dec                 eax
            //   4c8bcd               | lea                 ecx, [ebp - 0x40]
            //   4c89642420           | nop                 

        $sequence_8 = { e8???????? 8bd6 488bcf e8???????? 8b97a0050000 488bcf e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bd6                 | dec                 eax
            //   488bcf               | mov                 edi, 0xffffffff
            //   e8????????           |                     
            //   8b97a0050000         | dec                 ecx
            //   488bcf               | mov                 dword ptr [ebx - 0x38], edi
            //   e8????????           |                     

        $sequence_9 = { 448bc8 ba3b050000 e8???????? f644243002 7446 488b8b00020000 4885c9 }
            // n = 7, score = 100
            //   448bc8               | mov                 edx, 0xad
            //   ba3b050000           | jmp                 0x10ec
            //   e8????????           |                     
            //   f644243002           | mov                 edx, 0x9b7
            //   7446                 | jmp                 0x10ec
            //   488b8b00020000       | mov                 edx, 0x9b6
            //   4885c9               | jmp                 0x10ec

    condition:
        7 of them and filesize < 1420288
}