rule win_sunorcal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sunorcal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sunorcal"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5b c21000 8b442404 8b00 813863736de0 752a 83781003 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   c21000               | ret                 0x10
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   813863736de0         | cmp                 dword ptr [eax], 0xe06d7363
            //   752a                 | jne                 0x2c
            //   83781003             | cmp                 dword ptr [eax + 0x10], 3

        $sequence_1 = { 6a03 e8???????? cc 55 8bec 83ec0c }
            // n = 6, score = 200
            //   6a03                 | push                3
            //   e8????????           |                     
            //   cc                   | int3                
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc

        $sequence_2 = { 6a03 e8???????? cc 55 8bec 83ec0c a1???????? }
            // n = 7, score = 200
            //   6a03                 | push                3
            //   e8????????           |                     
            //   cc                   | int3                
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc
            //   a1????????           |                     

        $sequence_3 = { 68b7000000 ff15???????? 6a64 68???????? 6a67 }
            // n = 5, score = 200
            //   68b7000000           | push                0xb7
            //   ff15????????         |                     
            //   6a64                 | push                0x64
            //   68????????           |                     
            //   6a67                 | push                0x67

        $sequence_4 = { 68???????? ff15???????? 33c0 c3 c3 55 8bec }
            // n = 7, score = 200
            //   68????????           |                     
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_5 = { ff15???????? 68b7000000 ff15???????? 6a64 68???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   68b7000000           | push                0xb7
            //   ff15????????         |                     
            //   6a64                 | push                0x64
            //   68????????           |                     

        $sequence_6 = { ff15???????? 6a03 e8???????? cc 55 8bec 83ec0c }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   6a03                 | push                3
            //   e8????????           |                     
            //   cc                   | int3                
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc

        $sequence_7 = { c21000 8b442404 8b00 813863736de0 752a 83781003 7524 }
            // n = 7, score = 200
            //   c21000               | ret                 0x10
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   813863736de0         | cmp                 dword ptr [eax], 0xe06d7363
            //   752a                 | jne                 0x2c
            //   83781003             | cmp                 dword ptr [eax + 0x10], 3
            //   7524                 | jne                 0x26

        $sequence_8 = { c21000 8b442404 8b00 813863736de0 }
            // n = 4, score = 200
            //   c21000               | ret                 0x10
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   813863736de0         | cmp                 dword ptr [eax], 0xe06d7363

        $sequence_9 = { 7c02 eb0e e8???????? e8???????? 85c0 }
            // n = 5, score = 200
            //   7c02                 | jl                  4
            //   eb0e                 | jmp                 0x10
            //   e8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 172032
}