rule win_supper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.supper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.supper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { baffffffff 89cb 488b0d???????? ff15???????? }
            // n = 4, score = 1200
            //   baffffffff           | ret                 
            //   89cb                 | xor                 eax, eax
            //   488b0d????????       |                     
            //   ff15????????         |                     

        $sequence_1 = { 74ed 8844242f e8???????? 0fb644242f 48c705????????00000000 4883c438 }
            // n = 6, score = 1200
            //   74ed                 | je                  0xffffffef
            //   8844242f             | mov                 byte ptr [esp + 0x2f], al
            //   e8????????           |                     
            //   0fb644242f           | movzx               eax, byte ptr [esp + 0x2f]
            //   48c705????????00000000     |     
            //   4883c438             | dec                 eax

        $sequence_2 = { 488905???????? e8???????? 84c0 7407 4883c438 5b }
            // n = 6, score = 1200
            //   488905????????       |                     
            //   e8????????           |                     
            //   84c0                 | mov                 ecx, dword ptr [ebx + 8]
            //   7407                 | mov                 edx, 1
            //   4883c438             | inc                 ecx
            //   5b                   | call                esp

        $sequence_3 = { 488905???????? ffd6 48891d???????? 488905???????? }
            // n = 4, score = 1200
            //   488905????????       |                     
            //   ffd6                 | xor                 eax, eax
            //   48891d????????       |                     
            //   488905????????       |                     

        $sequence_4 = { 4889cb 31c9 ffd6 4531c0 31d2 31c9 }
            // n = 6, score = 1200
            //   4889cb               | add                 esp, 0x38
            //   31c9                 | dec                 eax
            //   ffd6                 | mov                 ebx, ecx
            //   4531c0               | xor                 ecx, ecx
            //   31d2                 | call                esi
            //   31c9                 | inc                 ebp

        $sequence_5 = { 488905???????? 31c0 4883c428 5b 5e c3 }
            // n = 6, score = 1200
            //   488905????????       |                     
            //   31c0                 | xor                 edx, edx
            //   4883c428             | xor                 ecx, ecx
            //   5b                   | call                esi
            //   5e                   | xor                 eax, eax
            //   c3                   | dec                 eax

        $sequence_6 = { ba01000000 4c8b25???????? 41ffd4 85c0 }
            // n = 4, score = 1200
            //   ba01000000           | inc                 ebp
            //   4c8b25????????       |                     
            //   41ffd4               | xor                 eax, eax
            //   85c0                 | dec                 eax

        $sequence_7 = { 4531c0 488b4b08 ba01000000 41ffd4 85c0 }
            // n = 5, score = 1200
            //   4531c0               | dec                 eax
            //   488b4b08             | add                 esp, 0x28
            //   ba01000000           | pop                 ebx
            //   41ffd4               | mov                 edx, 0xffffffff
            //   85c0                 | mov                 ebx, ecx

        $sequence_8 = { e8???????? 488b4510 488b00 4885c0 }
            // n = 4, score = 1000
            //   e8????????           |                     
            //   488b4510             | dec                 eax
            //   488b00               | mov                 ecx, dword ptr [ebx + 8]
            //   4885c0               | mov                 edx, 1

        $sequence_9 = { 0fb700 0fb7d0 488b85c0000000 4883c004 4189d0 }
            // n = 5, score = 300
            //   0fb700               | dec                 eax
            //   0fb7d0               | mov                 eax, dword ptr [eax]
            //   488b85c0000000       | dec                 eax
            //   4883c004             | test                eax, eax
            //   4189d0               | mov                 word ptr [ebp + 0x10], ax

        $sequence_10 = { 66894510 c645ff00 488b05???????? baffffffff }
            // n = 4, score = 300
            //   66894510             | inc                 ecx
            //   c645ff00             | call                esp
            //   488b05????????       |                     
            //   baffffffff           | test                eax, eax

        $sequence_11 = { 4883bdc000000000 750a b800000000 e9???????? 488b85c0000000 }
            // n = 5, score = 300
            //   4883bdc000000000     | mov                 byte ptr [ebp - 1], 0
            //   750a                 | mov                 edx, 0xffffffff
            //   b800000000           | mov                 dword ptr [esp + 0x20], 4
            //   e9????????           |                     
            //   488b85c0000000       | dec                 ecx

        $sequence_12 = { ba04000000 4889c1 e8???????? 488b85e0000000 }
            // n = 4, score = 300
            //   ba04000000           | mov                 ecx, 0x7d0
            //   4889c1               | dec                 eax
            //   e8????????           |                     
            //   488b85e0000000       | add                 esp, 0x28

        $sequence_13 = { 4889c1 e8???????? 8b45dc 89c0 4889c1 e8???????? }
            // n = 6, score = 300
            //   4889c1               | je                  0xb
            //   e8????????           |                     
            //   8b45dc               | dec                 eax
            //   89c0                 | add                 esp, 0x38
            //   4889c1               | pop                 ebx
            //   e8????????           |                     

        $sequence_14 = { c744242004000000 4989d1 41b801000000 ba06000000 4889c1 e8???????? }
            // n = 6, score = 300
            //   c744242004000000     | mov                 edx, 1
            //   4989d1               | inc                 ecx
            //   41b801000000         | call                esp
            //   ba06000000           | test                eax, eax
            //   4889c1               | test                al, al
            //   e8????????           |                     

        $sequence_15 = { c3 55 4881ec50010000 488dac2480000000 48898de0000000 488b85e0000000 0fb7400c }
            // n = 7, score = 300
            //   c3                   | pop                 ebx
            //   55                   | dec                 eax
            //   4881ec50010000       | test                ecx, ecx
            //   488dac2480000000     | je                  0x15
            //   48898de0000000       | mov                 ecx, 0x7d0
            //   488b85e0000000       | dec                 eax
            //   0fb7400c             | mov                 eax, dword ptr [ebp + 0x10]

    condition:
        7 of them and filesize < 517120
}