rule win_svcready_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.svcready."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.svcready"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895c2410 8bc7 896c2418 f7d2 33c6 0bfa 21542410 }
            // n = 7, score = 500
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   8bc7                 | mov                 eax, edi
            //   896c2418             | mov                 dword ptr [esp + 0x18], ebp
            //   f7d2                 | not                 edx
            //   33c6                 | xor                 eax, esi
            //   0bfa                 | or                  edi, edx
            //   21542410             | and                 dword ptr [esp + 0x10], edx

        $sequence_1 = { eb02 33f6 895d28 8d4702 }
            // n = 4, score = 500
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   895d28               | mov                 dword ptr [ebp + 0x28], ebx
            //   8d4702               | lea                 eax, [edi + 2]

        $sequence_2 = { 89442410 33c0 89742414 896c2418 895c241c ab }
            // n = 6, score = 500
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   33c0                 | xor                 eax, eax
            //   89742414             | mov                 dword ptr [esp + 0x14], esi
            //   896c2418             | mov                 dword ptr [esp + 0x18], ebp
            //   895c241c             | mov                 dword ptr [esp + 0x1c], ebx
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_3 = { 66c7070100 885f02 891e 885e04 895e08 895e0c 895dfc }
            // n = 7, score = 500
            //   66c7070100           | mov                 word ptr [edi], 1
            //   885f02               | mov                 byte ptr [edi + 2], bl
            //   891e                 | mov                 dword ptr [esi], ebx
            //   885e04               | mov                 byte ptr [esi + 4], bl
            //   895e08               | mov                 dword ptr [esi + 8], ebx
            //   895e0c               | mov                 dword ptr [esi + 0xc], ebx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx

        $sequence_4 = { 8b442428 40 50 57 51 }
            // n = 5, score = 500
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   57                   | push                edi
            //   51                   | push                ecx

        $sequence_5 = { 8b01 8902 83c204 83c104 894dec 8b45e8 ebea }
            // n = 7, score = 500
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8902                 | mov                 dword ptr [edx], eax
            //   83c204               | add                 edx, 4
            //   83c104               | add                 ecx, 4
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   ebea                 | jmp                 0xffffffec

        $sequence_6 = { 50 ff74241c ff15???????? 33c0 8d7c2408 ab }
            // n = 6, score = 500
            //   50                   | push                eax
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   8d7c2408             | lea                 edi, [esp + 8]
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_7 = { 8bca 8dbefc600000 f3ab 8bca }
            // n = 4, score = 500
            //   8bca                 | mov                 ecx, edx
            //   8dbefc600000         | lea                 edi, [esi + 0x60fc]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8bca                 | mov                 ecx, edx

        $sequence_8 = { 2bd1 8b7c2414 2bf1 c1fa02 c1fe02 3bfa 7678 }
            // n = 7, score = 500
            //   2bd1                 | sub                 edx, ecx
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   2bf1                 | sub                 esi, ecx
            //   c1fa02               | sar                 edx, 2
            //   c1fe02               | sar                 esi, 2
            //   3bfa                 | cmp                 edi, edx
            //   7678                 | jbe                 0x7a

        $sequence_9 = { 3c58 7504 897c2414 52 51 e8???????? 89442430 }
            // n = 7, score = 500
            //   3c58                 | cmp                 al, 0x58
            //   7504                 | jne                 6
            //   897c2414             | mov                 dword ptr [esp + 0x14], edi
            //   52                   | push                edx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   89442430             | mov                 dword ptr [esp + 0x30], eax

    condition:
        7 of them and filesize < 1187840
}