rule win_sykipot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sykipot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sykipot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d842494030000 68???????? 50 ffd6 83c40c 85c0 0f85fd000000 }
            // n = 7, score = 200
            //   8d842494030000       | lea                 eax, [esp + 0x394]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f85fd000000         | jne                 0x103

        $sequence_1 = { 8bcd 83e103 8d442410 f3a4 }
            // n = 4, score = 200
            //   8bcd                 | mov                 ecx, ebp
            //   83e103               | and                 ecx, 3
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_2 = { b93f000000 33c0 8dbc2469060000 88942468070000 f3ab }
            // n = 5, score = 200
            //   b93f000000           | mov                 ecx, 0x3f
            //   33c0                 | xor                 eax, eax
            //   8dbc2469060000       | lea                 edi, [esp + 0x669]
            //   88942468070000       | mov                 byte ptr [esp + 0x768], dl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_3 = { 3bf3 89742438 751b 8d4c2424 }
            // n = 4, score = 200
            //   3bf3                 | cmp                 esi, ebx
            //   89742438             | mov                 dword ptr [esp + 0x38], esi
            //   751b                 | jne                 0x1d
            //   8d4c2424             | lea                 ecx, [esp + 0x24]

        $sequence_4 = { 83c408 85c0 75da 8b85e8feffff 8b8dd8feffff eb06 }
            // n = 6, score = 200
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   75da                 | jne                 0xffffffdc
            //   8b85e8feffff         | mov                 eax, dword ptr [ebp - 0x118]
            //   8b8dd8feffff         | mov                 ecx, dword ptr [ebp - 0x128]
            //   eb06                 | jmp                 8

        $sequence_5 = { c1e902 f3a5 8bcd 8d94248c010000 83e103 }
            // n = 5, score = 200
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bcd                 | mov                 ecx, ebp
            //   8d94248c010000       | lea                 edx, [esp + 0x18c]
            //   83e103               | and                 ecx, 3

        $sequence_6 = { aa c744241820000000 52 8d442428 50 ff15???????? 83c9ff }
            // n = 7, score = 200
            //   aa                   | stosb               byte ptr es:[edi], al
            //   c744241820000000     | mov                 dword ptr [esp + 0x18], 0x20
            //   52                   | push                edx
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_7 = { 8b94242c060000 56 8d842498000000 57 }
            // n = 4, score = 200
            //   8b94242c060000       | mov                 edx, dword ptr [esp + 0x62c]
            //   56                   | push                esi
            //   8d842498000000       | lea                 eax, [esp + 0x98]
            //   57                   | push                edi

        $sequence_8 = { 50 ffd6 83c40c 8d4c2428 51 68???????? 6a00 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c40c               | add                 esp, 0xc
            //   8d4c2428             | lea                 ecx, [esp + 0x28]
            //   51                   | push                ecx
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_9 = { e8???????? 83c410 68???????? ffd5 8d842488000000 50 ffd5 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   68????????           |                     
            //   ffd5                 | call                ebp
            //   8d842488000000       | lea                 eax, [esp + 0x88]
            //   50                   | push                eax
            //   ffd5                 | call                ebp

    condition:
        7 of them and filesize < 286720
}