rule win_sync_scheduler_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sync_scheduler."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sync_scheduler"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b910270000 ff15???????? 90 488b55f8 4883fa10 7231 }
            // n = 6, score = 100
            //   b910270000           | mov                 dword ptr [esp + 0x20], eax
            //   ff15????????         |                     
            //   90                   | inc                 ebp
            //   488b55f8             | xor                 eax, eax
            //   4883fa10             | xor                 edx, edx
            //   7231                 | dec                 ecx

        $sequence_1 = { 498bcd ff15???????? 498bcc ff15???????? e9???????? 0f57c0 }
            // n = 6, score = 100
            //   498bcd               | lea                 eax, [esi + 0xbc80]
            //   ff15????????         |                     
            //   498bcc               | dec                 eax
            //   ff15????????         |                     
            //   e9????????           |                     
            //   0f57c0               | mov                 dword ptr [ebp + 0x220], eax

        $sequence_2 = { 33d2 488bc8 ff15???????? 488d0557570000 488903 48896e60 48895e08 }
            // n = 7, score = 100
            //   33d2                 | dec                 eax
            //   488bc8               | lea                 edx, [0xa44f]
            //   ff15????????         |                     
            //   488d0557570000       | dec                 eax
            //   488903               | lea                 ecx, [ebp + 0x10]
            //   48896e60             | nop                 
            //   48895e08             | xorps               xmm1, xmm1

        $sequence_3 = { c6450668 c6450777 c6450855 c6450968 c6450a64 c6450b67 c6450c49 }
            // n = 7, score = 100
            //   c6450668             | mov                 byte ptr [esp + 0x4d], 0x3e
            //   c6450777             | mov                 byte ptr [esp + 0x4e], 0x34
            //   c6450855             | mov                 byte ptr [esp + 0x4f], 0x38
            //   c6450968             | mov                 byte ptr [esp + 0x50], 0x33
            //   c6450a64             | mov                 byte ptr [esp + 0x51], 0x32
            //   c6450b67             | mov                 byte ptr [esp + 0x4c], 0x39
            //   c6450c49             | mov                 byte ptr [esp + 0x4d], 0x3e

        $sequence_4 = { 480f42d8 48b8ffffffffffffff7f 488d4b01 483bc8 0f87ad000000 4803c9 4881f900100000 }
            // n = 7, score = 100
            //   480f42d8             | xor                 al, 0x74
            //   48b8ffffffffffffff7f     | mov    byte ptr [esp + 0x43], al
            //   488d4b01             | mov                 eax, dword ptr [esp + 0x38]
            //   483bc8               | xor                 al, 0x65
            //   0f87ad000000         | mov                 byte ptr [esp + 0x48], al
            //   4803c9               | mov                 eax, dword ptr [esp + 0x38]
            //   4881f900100000       | add                 al, 0xd

        $sequence_5 = { 75cb 32db 4883fe10 7238 488d5601 }
            // n = 5, score = 100
            //   75cb                 | mov                 dword ptr [esi + 0x18], edi
            //   32db                 | dec                 eax
            //   4883fe10             | mov                 ecx, ebx
            //   7238                 | dec                 ecx
            //   488d5601             | cmp                 esi, 0x10

        $sequence_6 = { e8???????? 488d0d9c090000 e8???????? e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   488d0d9c090000       | movzx               eax, byte ptr [ebp - 0x55]
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_7 = { c645f277 c645f377 c645f46e c645f56c c645f67d }
            // n = 5, score = 100
            //   c645f277             | mov                 eax, dword ptr [esp + 0x50]
            //   c645f377             | mov                 eax, dword ptr [esp + 0x50]
            //   c645f46e             | add                 al, 5
            //   c645f56c             | xor                 al, 0x65
            //   c645f67d             | mov                 byte ptr [esp + 0x59], al

        $sequence_8 = { 488905???????? c7458017000000 8b4580 3448 }
            // n = 4, score = 100
            //   488905????????       |                     
            //   c7458017000000       | lea                 eax, [0x5137]
            //   8b4580               | mov                 ebx, edx
            //   3448                 | dec                 eax

        $sequence_9 = { c6456800 33d2 41b808010000 488d8d20020000 e8???????? 498d8680bc0000 }
            // n = 6, score = 100
            //   c6456800             | mov                 byte ptr [esp + 0x46], 0x3b
            //   33d2                 | mov                 byte ptr [esp + 0x47], 0x1e
            //   41b808010000         | mov                 byte ptr [esp + 0x48], 0x39
            //   488d8d20020000       | mov                 byte ptr [esp + 0x49], 0x3e
            //   e8????????           |                     
            //   498d8680bc0000       | mov                 byte ptr [esp + 0x4a], 0x23

    condition:
        7 of them and filesize < 156672
}