rule win_synccrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.synccrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.synccrypt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8d43d0 6683f809 0f8654010000 8d439f 6683f805 0f8653010000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d43d0               | lea                 eax, [ebx - 0x30]
            //   6683f809             | cmp                 ax, 9
            //   0f8654010000         | jbe                 0x15a
            //   8d439f               | lea                 eax, [ebx - 0x61]
            //   6683f805             | cmp                 ax, 5
            //   0f8653010000         | jbe                 0x159

        $sequence_1 = { c7465800000000 893c24 c744240440000000 e8???????? 8b06 8903 8b4604 }
            // n = 7, score = 100
            //   c7465800000000       | mov                 dword ptr [esi + 0x58], 0
            //   893c24               | mov                 dword ptr [esp], edi
            //   c744240440000000     | mov                 dword ptr [esp + 4], 0x40
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8903                 | mov                 dword ptr [ebx], eax
            //   8b4604               | mov                 eax, dword ptr [esi + 4]

        $sequence_2 = { 891c24 c744240400000000 bb01000000 e8???????? c744240c32010000 c7442408???????? c74424041e000000 }
            // n = 7, score = 100
            //   891c24               | mov                 dword ptr [esp], ebx
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   bb01000000           | mov                 ebx, 1
            //   e8????????           |                     
            //   c744240c32010000     | mov                 dword ptr [esp + 0xc], 0x132
            //   c7442408????????     |                     
            //   c74424041e000000     | mov                 dword ptr [esp + 4], 0x1e

        $sequence_3 = { c1fa02 29c2 8d0492 01c0 29c1 85d2 0fb68181e65800 }
            // n = 7, score = 100
            //   c1fa02               | sar                 edx, 2
            //   29c2                 | sub                 edx, eax
            //   8d0492               | lea                 eax, [edx + edx*4]
            //   01c0                 | add                 eax, eax
            //   29c1                 | sub                 ecx, eax
            //   85d2                 | test                edx, edx
            //   0fb68181e65800       | movzx               eax, byte ptr [ecx + 0x58e681]

        $sequence_4 = { c7442408???????? c744240426000000 c704240a000000 e8???????? 833d????????ff 0f851cfeffff eb8d }
            // n = 7, score = 100
            //   c7442408????????     |                     
            //   c744240426000000     | mov                 dword ptr [esp + 4], 0x26
            //   c704240a000000       | mov                 dword ptr [esp], 0xa
            //   e8????????           |                     
            //   833d????????ff       |                     
            //   0f851cfeffff         | jne                 0xfffffe22
            //   eb8d                 | jmp                 0xffffff8f

        $sequence_5 = { c744240878000000 c74424048e000000 c7042426000000 e8???????? 83caff e9???????? c744245caab75900 }
            // n = 7, score = 100
            //   c744240878000000     | mov                 dword ptr [esp + 8], 0x78
            //   c74424048e000000     | mov                 dword ptr [esp + 4], 0x8e
            //   c7042426000000       | mov                 dword ptr [esp], 0x26
            //   e8????????           |                     
            //   83caff               | or                  edx, 0xffffffff
            //   e9????????           |                     
            //   c744245caab75900     | mov                 dword ptr [esp + 0x5c], 0x59b7aa

        $sequence_6 = { e8???????? 893424 89c3 e8???????? 29c3 7876 39fb }
            // n = 7, score = 100
            //   e8????????           |                     
            //   893424               | mov                 dword ptr [esp], esi
            //   89c3                 | mov                 ebx, eax
            //   e8????????           |                     
            //   29c3                 | sub                 ebx, eax
            //   7876                 | js                  0x78
            //   39fb                 | cmp                 ebx, edi

        $sequence_7 = { c7433c00000000 c7434000000000 891c24 ff5608 85c0 7411 83c424 }
            // n = 7, score = 100
            //   c7433c00000000       | mov                 dword ptr [ebx + 0x3c], 0
            //   c7434000000000       | mov                 dword ptr [ebx + 0x40], 0
            //   891c24               | mov                 dword ptr [esp], ebx
            //   ff5608               | call                dword ptr [esi + 8]
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   83c424               | add                 esp, 0x24

        $sequence_8 = { 896c2404 893c24 e8???????? 893c24 e8???????? 8b442424 83c43c }
            // n = 7, score = 100
            //   896c2404             | mov                 dword ptr [esp + 4], ebp
            //   893c24               | mov                 dword ptr [esp], edi
            //   e8????????           |                     
            //   893c24               | mov                 dword ptr [esp], edi
            //   e8????????           |                     
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   83c43c               | add                 esp, 0x3c

        $sequence_9 = { c7442404???????? 893424 e8???????? 85c0 0f8ff3feffff e9???????? c7442404???????? }
            // n = 7, score = 100
            //   c7442404????????     |                     
            //   893424               | mov                 dword ptr [esp], esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8ff3feffff         | jg                  0xfffffef9
            //   e9????????           |                     
            //   c7442404????????     |                     

    condition:
        7 of them and filesize < 4489216
}