rule win_synflooder_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.synflooder."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.synflooder"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 762a 56 e8???????? 8d0445f4f34000 8bc8 }
            // n = 5, score = 200
            //   762a                 | jbe                 0x2c
            //   56                   | push                esi
            //   e8????????           |                     
            //   8d0445f4f34000       | lea                 eax, [eax*2 + 0x40f3f4]
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { 8be5 5d c3 8b35???????? b802000000 6a50 668944242c }
            // n = 7, score = 200
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b35????????         |                     
            //   b802000000           | mov                 eax, 2
            //   6a50                 | push                0x50
            //   668944242c           | mov                 word ptr [esp + 0x2c], ax

        $sequence_2 = { 8bec 8b4508 ff34c580e44000 ff15???????? 5d }
            // n = 5, score = 200
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff34c580e44000       | push                dword ptr [eax*8 + 0x40e480]
            //   ff15????????         |                     
            //   5d                   | pop                 ebp

        $sequence_3 = { 0f8f0b010000 33f6 85db 7e1b 8bff e8???????? 0fbec0 }
            // n = 7, score = 200
            //   0f8f0b010000         | jg                  0x111
            //   33f6                 | xor                 esi, esi
            //   85db                 | test                ebx, ebx
            //   7e1b                 | jle                 0x1d
            //   8bff                 | mov                 edi, edi
            //   e8????????           |                     
            //   0fbec0               | movsx               eax, al

        $sequence_4 = { 8a13 0fb6ca 0fbe8910ee4000 85c9 }
            // n = 4, score = 200
            //   8a13                 | mov                 dl, byte ptr [ebx]
            //   0fb6ca               | movzx               ecx, dl
            //   0fbe8910ee4000       | movsx               ecx, byte ptr [ecx + 0x40ee10]
            //   85c9                 | test                ecx, ecx

        $sequence_5 = { 897e70 c686c800000043 c6864b01000043 c74668f0e54000 }
            // n = 4, score = 200
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c74668f0e54000       | mov                 dword ptr [esi + 0x68], 0x40e5f0

        $sequence_6 = { 03048d20fc4000 eb02 8bc2 f6402480 }
            // n = 4, score = 200
            //   03048d20fc4000       | add                 eax, dword ptr [ecx*4 + 0x40fc20]
            //   eb02                 | jmp                 4
            //   8bc2                 | mov                 eax, edx
            //   f6402480             | test                byte ptr [eax + 0x24], 0x80

        $sequence_7 = { 33c5 8945fc 8d8568faffff 50 6a02 ff15???????? }
            // n = 6, score = 200
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8d8568faffff         | lea                 eax, [ebp - 0x598]
            //   50                   | push                eax
            //   6a02                 | push                2
            //   ff15????????         |                     

        $sequence_8 = { c7470640008006 8b44242c 50 ff15???????? }
            // n = 4, score = 200
            //   c7470640008006       | mov                 dword ptr [edi + 6], 0x6800040
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { 897df4 85ff 75d1 53 e8???????? 8b45f0 }
            // n = 6, score = 200
            //   897df4               | mov                 dword ptr [ebp - 0xc], edi
            //   85ff                 | test                edi, edi
            //   75d1                 | jne                 0xffffffd3
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

    condition:
        7 of them and filesize < 163840
}